/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class ConfigurationPropertyNameAliases
implements Iterable<ConfigurationPropertyName> {
    private final MultiValueMap<ConfigurationPropertyName, ConfigurationPropertyName> aliases = new LinkedMultiValueMap<ConfigurationPropertyName, ConfigurationPropertyName>();

    public ConfigurationPropertyNameAliases() {
    }

    public ConfigurationPropertyNameAliases(String name2, String ... aliases2) {
        this.addAliases(name2, aliases2);
    }

    public ConfigurationPropertyNameAliases(ConfigurationPropertyName name2, ConfigurationPropertyName ... aliases2) {
        this.addAliases(name2, aliases2);
    }

    public void addAliases(String name2, String ... aliases2) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull((Object)aliases2, "Aliases must not be null");
        this.addAliases(ConfigurationPropertyName.of(name2), (ConfigurationPropertyName[])Arrays.stream(aliases2).map(ConfigurationPropertyName::of).toArray(ConfigurationPropertyName[]::new));
    }

    public void addAliases(ConfigurationPropertyName name2, ConfigurationPropertyName ... aliases2) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull((Object)aliases2, "Aliases must not be null");
        this.aliases.addAll(name2, Arrays.asList(aliases2));
    }

    public List<ConfigurationPropertyName> getAliases(ConfigurationPropertyName name2) {
        return this.aliases.getOrDefault(name2, (ConfigurationPropertyName)((Object)Collections.emptyList()));
    }

    public ConfigurationPropertyName getNameForAlias(ConfigurationPropertyName alias) {
        return this.aliases.entrySet().stream().filter(e -> ((List)e.getValue()).contains(alias)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return this.aliases.keySet().iterator();
    }
}

