/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyNameException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ConfigurationPropertyName
implements Comparable<ConfigurationPropertyName> {
    private static final String EMPTY_STRING = "";
    public static final ConfigurationPropertyName EMPTY = new ConfigurationPropertyName(Elements.EMPTY);
    private final Elements elements;
    private final CharSequence[] uniformElements;
    private String string;
    private int hashCode;

    private ConfigurationPropertyName(Elements elements) {
        this.elements = elements;
        this.uniformElements = new CharSequence[elements.getSize()];
    }

    public boolean isEmpty() {
        return this.elements.getSize() == 0;
    }

    public boolean isLastElementIndexed() {
        int size2 = this.getNumberOfElements();
        return size2 > 0 && this.isIndexed(size2 - 1);
    }

    public boolean hasIndexedElement() {
        for (int i2 = 0; i2 < this.getNumberOfElements(); ++i2) {
            if (!this.isIndexed(i2)) continue;
            return true;
        }
        return false;
    }

    boolean isIndexed(int elementIndex) {
        return this.elements.getType(elementIndex).isIndexed();
    }

    public boolean isNumericIndex(int elementIndex) {
        return this.elements.getType(elementIndex) == ElementType.NUMERICALLY_INDEXED;
    }

    public String getLastElement(Form form) {
        int size2 = this.getNumberOfElements();
        return size2 != 0 ? this.getElement(size2 - 1, form) : EMPTY_STRING;
    }

    public String getElement(int elementIndex, Form form) {
        CharSequence element = this.elements.get(elementIndex);
        ElementType type2 = this.elements.getType(elementIndex);
        if (type2.isIndexed()) {
            return element.toString();
        }
        if (form == Form.ORIGINAL) {
            if (type2 != ElementType.NON_UNIFORM) {
                return element.toString();
            }
            return this.convertToOriginalForm(element).toString();
        }
        if (form == Form.DASHED) {
            if (type2 == ElementType.UNIFORM || type2 == ElementType.DASHED) {
                return element.toString();
            }
            return this.convertToDashedElement(element).toString();
        }
        CharSequence uniformElement = this.uniformElements[elementIndex];
        if (uniformElement == null) {
            uniformElement = type2 != ElementType.UNIFORM ? this.convertToUniformElement(element) : element;
            this.uniformElements[elementIndex] = uniformElement.toString();
        }
        return uniformElement.toString();
    }

    private CharSequence convertToOriginalForm(CharSequence element) {
        return this.convertElement(element, false, (ch, i2) -> ch == '_' || ElementsParser.isValidChar(Character.toLowerCase(ch), i2));
    }

    private CharSequence convertToDashedElement(CharSequence element) {
        return this.convertElement(element, true, ElementsParser::isValidChar);
    }

    private CharSequence convertToUniformElement(CharSequence element) {
        return this.convertElement(element, true, (ch, i2) -> ElementsParser.isAlphaNumeric(ch));
    }

    private CharSequence convertElement(CharSequence element, boolean lowercase, ElementCharPredicate filter2) {
        StringBuilder result2 = new StringBuilder(element.length());
        for (int i2 = 0; i2 < element.length(); ++i2) {
            char ch;
            char c = ch = lowercase ? Character.toLowerCase(element.charAt(i2)) : element.charAt(i2);
            if (!filter2.test(ch, i2)) continue;
            result2.append(ch);
        }
        return result2;
    }

    public int getNumberOfElements() {
        return this.elements.getSize();
    }

    public ConfigurationPropertyName append(String suffix) {
        if (!StringUtils.hasLength(suffix)) {
            return this;
        }
        Elements additionalElements = ConfigurationPropertyName.probablySingleElementOf(suffix);
        return new ConfigurationPropertyName(this.elements.append(additionalElements));
    }

    public ConfigurationPropertyName append(ConfigurationPropertyName suffix) {
        if (suffix == null) {
            return this;
        }
        return new ConfigurationPropertyName(this.elements.append(suffix.elements));
    }

    public ConfigurationPropertyName getParent() {
        int numberOfElements = this.getNumberOfElements();
        return numberOfElements <= 1 ? EMPTY : this.chop(numberOfElements - 1);
    }

    public ConfigurationPropertyName chop(int size2) {
        if (size2 >= this.getNumberOfElements()) {
            return this;
        }
        return new ConfigurationPropertyName(this.elements.chop(size2));
    }

    public ConfigurationPropertyName subName(int offset2) {
        if (offset2 == 0) {
            return this;
        }
        if (offset2 == this.getNumberOfElements()) {
            return EMPTY;
        }
        if (offset2 < 0 || offset2 > this.getNumberOfElements()) {
            throw new IndexOutOfBoundsException("Offset: " + offset2 + ", NumberOfElements: " + this.getNumberOfElements());
        }
        return new ConfigurationPropertyName(this.elements.subElements(offset2));
    }

    public boolean isParentOf(ConfigurationPropertyName name2) {
        Assert.notNull((Object)name2, "Name must not be null");
        if (this.getNumberOfElements() != name2.getNumberOfElements() - 1) {
            return false;
        }
        return this.isAncestorOf(name2);
    }

    public boolean isAncestorOf(ConfigurationPropertyName name2) {
        Assert.notNull((Object)name2, "Name must not be null");
        if (this.getNumberOfElements() >= name2.getNumberOfElements()) {
            return false;
        }
        return this.elementsEqual(name2);
    }

    @Override
    public int compareTo(ConfigurationPropertyName other) {
        return this.compare(this, other);
    }

    private int compare(ConfigurationPropertyName n1, ConfigurationPropertyName n2) {
        int l1 = n1.getNumberOfElements();
        int l2 = n2.getNumberOfElements();
        int i1 = 0;
        int i2 = 0;
        while (i1 < l1 || i2 < l2) {
            try {
                ElementType type2;
                String e2;
                ElementType type1;
                String e1 = i1 < l1 ? n1.getElement(i1++, Form.UNIFORM) : null;
                int result2 = this.compare(e1, type1 = i1 < l1 ? n1.elements.getType(i1) : null, e2 = i2 < l2 ? n2.getElement(i2++, Form.UNIFORM) : null, type2 = i2 < l2 ? n2.elements.getType(i2) : null);
                if (result2 == 0) continue;
                return result2;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0;
    }

    private int compare(String e1, ElementType type1, String e2, ElementType type2) {
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        int result2 = Boolean.compare(type2.isIndexed(), type1.isIndexed());
        if (result2 != 0) {
            return result2;
        }
        if (type1 == ElementType.NUMERICALLY_INDEXED && type2 == ElementType.NUMERICALLY_INDEXED) {
            long v1 = Long.parseLong(e1);
            long v2 = Long.parseLong(e2);
            return Long.compare(v1, v2);
        }
        return e1.compareTo(e2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConfigurationPropertyName other = (ConfigurationPropertyName)obj;
        if (this.getNumberOfElements() != other.getNumberOfElements()) {
            return false;
        }
        if (this.elements.canShortcutWithSource(ElementType.UNIFORM) && other.elements.canShortcutWithSource(ElementType.UNIFORM)) {
            return this.toString().equals(other.toString());
        }
        return this.elementsEqual(other);
    }

    private boolean elementsEqual(ConfigurationPropertyName name2) {
        for (int i2 = this.elements.getSize() - 1; i2 >= 0; --i2) {
            if (!this.elementDiffers(this.elements, name2.elements, i2)) continue;
            return false;
        }
        return true;
    }

    private boolean elementDiffers(Elements e1, Elements e2, int i2) {
        ElementType type1 = e1.getType(i2);
        ElementType type2 = e2.getType(i2);
        if (type1.allowsFastEqualityCheck() && type2.allowsFastEqualityCheck()) {
            return !this.fastElementEquals(e1, e2, i2);
        }
        if (type1.allowsDashIgnoringEqualityCheck() && type2.allowsDashIgnoringEqualityCheck()) {
            return !this.dashIgnoringElementEquals(e1, e2, i2);
        }
        return !this.defaultElementEquals(e1, e2, i2);
    }

    private boolean fastElementEquals(Elements e1, Elements e2, int i2) {
        int length2;
        int length1 = e1.getLength(i2);
        if (length1 == (length2 = e2.getLength(i2))) {
            int i1 = 0;
            while (length1-- != 0) {
                char ch2;
                char ch1 = e1.charAt(i2, i1);
                if (ch1 != (ch2 = e2.charAt(i2, i1))) {
                    return false;
                }
                ++i1;
            }
            return true;
        }
        return false;
    }

    private boolean dashIgnoringElementEquals(Elements e1, Elements e2, int i2) {
        int l1 = e1.getLength(i2);
        int l2 = e2.getLength(i2);
        int i1 = 0;
        int i22 = 0;
        while (i1 < l1) {
            if (i22 >= l2) {
                return this.remainderIsDashes(e1, i2, i1);
            }
            char ch1 = e1.charAt(i2, i1);
            char ch2 = e2.charAt(i2, i22);
            if (ch1 == '-') {
                ++i1;
                continue;
            }
            if (ch2 == '-') {
                ++i22;
                continue;
            }
            if (ch1 != ch2) {
                return false;
            }
            ++i1;
            ++i22;
        }
        if (i22 < l2) {
            if (e2.getType(i2).isIndexed()) {
                return false;
            }
            do {
                char ch2;
                if ((ch2 = e2.charAt(i2, i22++)) == '-') continue;
                return false;
            } while (i22 < l2);
        }
        return true;
    }

    private boolean defaultElementEquals(Elements e1, Elements e2, int i2) {
        int l1 = e1.getLength(i2);
        int l2 = e2.getLength(i2);
        boolean indexed1 = e1.getType(i2).isIndexed();
        boolean indexed2 = e2.getType(i2).isIndexed();
        int i1 = 0;
        int i22 = 0;
        while (i1 < l1) {
            char ch2;
            if (i22 >= l2) {
                return this.remainderIsNotAlphanumeric(e1, i2, i1);
            }
            char ch1 = indexed1 ? e1.charAt(i2, i1) : Character.toLowerCase(e1.charAt(i2, i1));
            char c = ch2 = indexed2 ? e2.charAt(i2, i22) : Character.toLowerCase(e2.charAt(i2, i22));
            if (!indexed1 && !ElementsParser.isAlphaNumeric(ch1)) {
                ++i1;
                continue;
            }
            if (!indexed2 && !ElementsParser.isAlphaNumeric(ch2)) {
                ++i22;
                continue;
            }
            if (ch1 != ch2) {
                return false;
            }
            ++i1;
            ++i22;
        }
        if (i22 < l2) {
            return this.remainderIsNotAlphanumeric(e2, i2, i22);
        }
        return true;
    }

    private boolean remainderIsNotAlphanumeric(Elements elements, int element, int index2) {
        if (elements.getType(element).isIndexed()) {
            return false;
        }
        int length2 = elements.getLength(element);
        do {
            char c;
            if (!ElementsParser.isAlphaNumeric(c = Character.toLowerCase(elements.charAt(element, index2++)))) continue;
            return false;
        } while (index2 < length2);
        return true;
    }

    private boolean remainderIsDashes(Elements elements, int element, int index2) {
        if (elements.getType(element).isIndexed()) {
            return false;
        }
        int length2 = elements.getLength(element);
        do {
            char c;
            if ((c = elements.charAt(element, index2++)) == '-') continue;
            return false;
        } while (index2 < length2);
        return true;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        Elements elements = this.elements;
        if (hashCode == 0 && elements.getSize() != 0) {
            for (int elementIndex = 0; elementIndex < elements.getSize(); ++elementIndex) {
                int elementHashCode = 0;
                boolean indexed = elements.getType(elementIndex).isIndexed();
                int length2 = elements.getLength(elementIndex);
                for (int i2 = 0; i2 < length2; ++i2) {
                    char ch = elements.charAt(elementIndex, i2);
                    if (!indexed) {
                        ch = Character.toLowerCase(ch);
                    }
                    if (!ElementsParser.isAlphaNumeric(ch)) continue;
                    elementHashCode = 31 * elementHashCode + ch;
                }
                hashCode = 31 * hashCode + elementHashCode;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.buildToString();
        }
        return this.string;
    }

    private String buildToString() {
        if (this.elements.canShortcutWithSource(ElementType.UNIFORM, ElementType.DASHED)) {
            return this.elements.getSource().toString();
        }
        int elements = this.getNumberOfElements();
        StringBuilder result2 = new StringBuilder(elements * 8);
        for (int i2 = 0; i2 < elements; ++i2) {
            boolean indexed = this.isIndexed(i2);
            if (!result2.isEmpty() && !indexed) {
                result2.append('.');
            }
            if (indexed) {
                result2.append('[');
                result2.append(this.getElement(i2, Form.ORIGINAL));
                result2.append(']');
                continue;
            }
            result2.append(this.getElement(i2, Form.DASHED));
        }
        return result2.toString();
    }

    public static boolean isValid(CharSequence name2) {
        return ConfigurationPropertyName.of(name2, true) != null;
    }

    public static ConfigurationPropertyName of(CharSequence name2) {
        return ConfigurationPropertyName.of(name2, false);
    }

    public static ConfigurationPropertyName ofIfValid(CharSequence name2) {
        return ConfigurationPropertyName.of(name2, true);
    }

    static ConfigurationPropertyName of(CharSequence name2, boolean returnNullIfInvalid) {
        Elements elements = ConfigurationPropertyName.elementsOf(name2, returnNullIfInvalid);
        return elements != null ? new ConfigurationPropertyName(elements) : null;
    }

    private static Elements probablySingleElementOf(CharSequence name2) {
        return ConfigurationPropertyName.elementsOf(name2, false, 1);
    }

    private static Elements elementsOf(CharSequence name2, boolean returnNullIfInvalid) {
        return ConfigurationPropertyName.elementsOf(name2, returnNullIfInvalid, 6);
    }

    private static Elements elementsOf(CharSequence name2, boolean returnNullIfInvalid, int parserCapacity) {
        if (name2 == null) {
            Assert.isTrue(returnNullIfInvalid, "Name must not be null");
            return null;
        }
        if (name2.isEmpty()) {
            return Elements.EMPTY;
        }
        if (name2.charAt(0) == '.' || name2.charAt(name2.length() - 1) == '.') {
            if (returnNullIfInvalid) {
                return null;
            }
            throw new InvalidConfigurationPropertyNameException(name2, Collections.singletonList(Character.valueOf('.')));
        }
        Elements elements = new ElementsParser(name2, '.', parserCapacity).parse();
        for (int i2 = 0; i2 < elements.getSize(); ++i2) {
            if (elements.getType(i2) != ElementType.NON_UNIFORM) continue;
            if (returnNullIfInvalid) {
                return null;
            }
            throw new InvalidConfigurationPropertyNameException(name2, ConfigurationPropertyName.getInvalidChars(elements, i2));
        }
        return elements;
    }

    private static List<Character> getInvalidChars(Elements elements, int index2) {
        ArrayList<Character> invalidChars = new ArrayList<Character>();
        for (int charIndex = 0; charIndex < elements.getLength(index2); ++charIndex) {
            char ch = elements.charAt(index2, charIndex);
            if (ElementsParser.isValidChar(ch, charIndex)) continue;
            invalidChars.add(Character.valueOf(ch));
        }
        return invalidChars;
    }

    public static ConfigurationPropertyName adapt(CharSequence name2, char separator) {
        return ConfigurationPropertyName.adapt(name2, separator, null);
    }

    static ConfigurationPropertyName adapt(CharSequence name2, char separator, Function<CharSequence, CharSequence> elementValueProcessor) {
        Assert.notNull((Object)name2, "Name must not be null");
        if (name2.isEmpty()) {
            return EMPTY;
        }
        Elements elements = new ElementsParser(name2, separator).parse(elementValueProcessor);
        if (elements.getSize() == 0) {
            return EMPTY;
        }
        return new ConfigurationPropertyName(elements);
    }

    private static class Elements {
        private static final int[] NO_POSITION = new int[0];
        private static final ElementType[] NO_TYPE = new ElementType[0];
        public static final Elements EMPTY = new Elements("", 0, NO_POSITION, NO_POSITION, NO_TYPE, null);
        private final CharSequence source;
        private final int size;
        private final int[] start;
        private final int[] end;
        private final ElementType[] type;
        private final CharSequence[] resolved;

        Elements(CharSequence source2, int size2, int[] start2, int[] end2, ElementType[] type2, CharSequence[] resolved) {
            this.source = source2;
            this.size = size2;
            this.start = start2;
            this.end = end2;
            this.type = type2;
            this.resolved = resolved;
        }

        Elements append(Elements additional) {
            int size2 = this.size + additional.size;
            ElementType[] type2 = new ElementType[size2];
            System.arraycopy(this.type, 0, type2, 0, this.size);
            System.arraycopy(additional.type, 0, type2, this.size, additional.size);
            CharSequence[] resolved = this.newResolved(size2);
            for (int i2 = 0; i2 < additional.size; ++i2) {
                resolved[this.size + i2] = additional.get(i2);
            }
            return new Elements(this.source, size2, this.start, this.end, type2, resolved);
        }

        Elements chop(int size2) {
            CharSequence[] resolved = this.newResolved(size2);
            return new Elements(this.source, size2, this.start, this.end, this.type, resolved);
        }

        Elements subElements(int offset2) {
            int size2 = this.size - offset2;
            CharSequence[] resolved = this.newResolved(size2);
            int[] start2 = new int[size2];
            System.arraycopy(this.start, offset2, start2, 0, size2);
            int[] end2 = new int[size2];
            System.arraycopy(this.end, offset2, end2, 0, size2);
            ElementType[] type2 = new ElementType[size2];
            System.arraycopy(this.type, offset2, type2, 0, size2);
            return new Elements(this.source, size2, start2, end2, type2, resolved);
        }

        private CharSequence[] newResolved(int size2) {
            CharSequence[] resolved = new CharSequence[size2];
            if (this.resolved != null) {
                System.arraycopy(this.resolved, 0, resolved, 0, Math.min(size2, this.size));
            }
            return resolved;
        }

        int getSize() {
            return this.size;
        }

        CharSequence get(int index2) {
            if (this.resolved != null && this.resolved[index2] != null) {
                return this.resolved[index2];
            }
            int start2 = this.start[index2];
            int end2 = this.end[index2];
            return this.source.subSequence(start2, end2);
        }

        int getLength(int index2) {
            if (this.resolved != null && this.resolved[index2] != null) {
                return this.resolved[index2].length();
            }
            int start2 = this.start[index2];
            int end2 = this.end[index2];
            return end2 - start2;
        }

        char charAt(int index2, int charIndex) {
            if (this.resolved != null && this.resolved[index2] != null) {
                return this.resolved[index2].charAt(charIndex);
            }
            int start2 = this.start[index2];
            return this.source.charAt(start2 + charIndex);
        }

        ElementType getType(int index2) {
            return this.type[index2];
        }

        CharSequence getSource() {
            return this.source;
        }

        boolean canShortcutWithSource(ElementType requiredType) {
            return this.canShortcutWithSource(requiredType, requiredType);
        }

        boolean canShortcutWithSource(ElementType requiredType, ElementType alternativeType) {
            if (this.resolved != null) {
                return false;
            }
            for (int i2 = 0; i2 < this.size; ++i2) {
                ElementType type2 = this.type[i2];
                if (type2 != requiredType && type2 != alternativeType) {
                    return false;
                }
                if (i2 <= 0 || this.end[i2 - 1] + 1 == this.start[i2]) continue;
                return false;
            }
            return true;
        }
    }

    private static enum ElementType {
        EMPTY(false),
        UNIFORM(false),
        DASHED(false),
        NON_UNIFORM(false),
        INDEXED(true),
        NUMERICALLY_INDEXED(true);

        private final boolean indexed;

        private ElementType(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public boolean allowsFastEqualityCheck() {
            return this == UNIFORM || this == NUMERICALLY_INDEXED;
        }

        public boolean allowsDashIgnoringEqualityCheck() {
            return this.allowsFastEqualityCheck() || this == DASHED;
        }
    }

    public static enum Form {
        ORIGINAL,
        DASHED,
        UNIFORM;

    }

    private static interface ElementCharPredicate {
        public boolean test(char var1, int var2);
    }

    private static class ElementsParser {
        private static final int DEFAULT_CAPACITY = 6;
        private final CharSequence source;
        private final char separator;
        private int size;
        private int[] start;
        private int[] end;
        private ElementType[] type;
        private CharSequence[] resolved;

        ElementsParser(CharSequence source2, char separator) {
            this(source2, separator, 6);
        }

        ElementsParser(CharSequence source2, char separator, int capacity) {
            this.source = source2;
            this.separator = separator;
            this.start = new int[capacity];
            this.end = new int[capacity];
            this.type = new ElementType[capacity];
        }

        Elements parse() {
            return this.parse(null);
        }

        Elements parse(Function<CharSequence, CharSequence> valueProcessor) {
            int length2 = this.source.length();
            int openBracketCount = 0;
            int start2 = 0;
            ElementType type2 = ElementType.EMPTY;
            for (int i2 = 0; i2 < length2; ++i2) {
                char ch = this.source.charAt(i2);
                if (ch == '[') {
                    if (openBracketCount == 0) {
                        this.add(start2, i2, type2, valueProcessor);
                        start2 = i2 + 1;
                        type2 = ElementType.NUMERICALLY_INDEXED;
                    }
                    ++openBracketCount;
                    continue;
                }
                if (ch == ']') {
                    if (--openBracketCount != 0) continue;
                    this.add(start2, i2, type2, valueProcessor);
                    start2 = i2 + 1;
                    type2 = ElementType.EMPTY;
                    continue;
                }
                if (!type2.isIndexed() && ch == this.separator) {
                    this.add(start2, i2, type2, valueProcessor);
                    start2 = i2 + 1;
                    type2 = ElementType.EMPTY;
                    continue;
                }
                type2 = this.updateType(type2, ch, i2 - start2);
            }
            if (openBracketCount != 0) {
                type2 = ElementType.NON_UNIFORM;
            }
            this.add(start2, length2, type2, valueProcessor);
            return new Elements(this.source, this.size, this.start, this.end, this.type, this.resolved);
        }

        private ElementType updateType(ElementType existingType, char ch, int index2) {
            if (existingType.isIndexed()) {
                if (existingType == ElementType.NUMERICALLY_INDEXED && !ElementsParser.isNumeric(ch)) {
                    return ElementType.INDEXED;
                }
                return existingType;
            }
            if (existingType == ElementType.EMPTY && ElementsParser.isValidChar(ch, index2)) {
                return index2 == 0 ? ElementType.UNIFORM : ElementType.NON_UNIFORM;
            }
            if (existingType == ElementType.UNIFORM && ch == '-') {
                return ElementType.DASHED;
            }
            if (!ElementsParser.isValidChar(ch, index2)) {
                if (existingType == ElementType.EMPTY && !ElementsParser.isValidChar(Character.toLowerCase(ch), index2)) {
                    return ElementType.EMPTY;
                }
                return ElementType.NON_UNIFORM;
            }
            return existingType;
        }

        private void add(int start2, int end2, ElementType type2, Function<CharSequence, CharSequence> valueProcessor) {
            if (end2 - start2 < 1 || type2 == ElementType.EMPTY) {
                return;
            }
            if (this.start.length == this.size) {
                this.start = this.expand(this.start);
                this.end = this.expand(this.end);
                this.type = this.expand(this.type);
                this.resolved = this.expand(this.resolved);
            }
            if (valueProcessor != null) {
                CharSequence resolved;
                Elements resolvedElements;
                if (this.resolved == null) {
                    this.resolved = new CharSequence[this.start.length];
                }
                Assert.state((resolvedElements = new ElementsParser(resolved = valueProcessor.apply(this.source.subSequence(start2, end2)), '.').parse()).getSize() == 1, "Resolved element must not contain multiple elements");
                this.resolved[this.size] = resolvedElements.get(0);
                type2 = resolvedElements.getType(0);
            }
            this.start[this.size] = start2;
            this.end[this.size] = end2;
            this.type[this.size] = type2;
            ++this.size;
        }

        private int[] expand(int[] src) {
            int[] dest = new int[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        private ElementType[] expand(ElementType[] src) {
            ElementType[] dest = new ElementType[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        private CharSequence[] expand(CharSequence[] src) {
            if (src == null) {
                return null;
            }
            CharSequence[] dest = new CharSequence[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        static boolean isValidChar(char ch, int index2) {
            return ElementsParser.isAlpha(ch) || ElementsParser.isNumeric(ch) || index2 != 0 && ch == '-';
        }

        static boolean isAlphaNumeric(char ch) {
            return ElementsParser.isAlpha(ch) || ElementsParser.isNumeric(ch);
        }

        private static boolean isAlpha(char ch) {
            return ch >= 'a' && ch <= 'z';
        }

        private static boolean isNumeric(char ch) {
            return ch >= '0' && ch <= '9';
        }
    }
}

