/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ConfigurationProperty
implements OriginProvider,
Comparable<ConfigurationProperty> {
    private final ConfigurationPropertyName name;
    private final Object value;
    private final ConfigurationPropertySource source;
    private final Origin origin;

    public ConfigurationProperty(ConfigurationPropertyName name2, Object value2, Origin origin) {
        this(null, name2, value2, origin);
    }

    private ConfigurationProperty(ConfigurationPropertySource source2, ConfigurationPropertyName name2, Object value2, Origin origin) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull(value2, "Value must not be null");
        this.source = source2;
        this.name = name2;
        this.value = value2;
        this.origin = origin;
    }

    public ConfigurationPropertySource getSource() {
        return this.source;
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationProperty other = (ConfigurationProperty)obj;
        boolean result2 = true;
        result2 = result2 && ObjectUtils.nullSafeEquals(this.name, other.name);
        result2 = result2 && ObjectUtils.nullSafeEquals(this.value, other.value);
        return result2;
    }

    public int hashCode() {
        int result2 = ObjectUtils.nullSafeHashCode(this.name);
        result2 = 31 * result2 + ObjectUtils.nullSafeHashCode(this.value);
        return result2;
    }

    public String toString() {
        return new ToStringCreator(this).append("name", this.name).append("value", this.value).append("origin", this.origin).toString();
    }

    @Override
    public int compareTo(ConfigurationProperty other) {
        return this.name.compareTo(other.name);
    }

    static ConfigurationProperty of(ConfigurationPropertyName name2, OriginTrackedValue value2) {
        if (value2 == null) {
            return null;
        }
        return new ConfigurationProperty(name2, value2.getValue(), value2.getOrigin());
    }

    static ConfigurationProperty of(ConfigurationPropertySource source2, ConfigurationPropertyName name2, Object value2, Origin origin) {
        if (value2 == null) {
            return null;
        }
        return new ConfigurationProperty(source2, name2, value2, origin);
    }
}

