/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.List;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.AliasedConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.util.CollectionUtils;

class AliasedIterableConfigurationPropertySource
extends AliasedConfigurationPropertySource
implements IterableConfigurationPropertySource {
    AliasedIterableConfigurationPropertySource(IterableConfigurationPropertySource source2, ConfigurationPropertyNameAliases aliases2) {
        super(source2, aliases2);
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        return this.getSource().stream().flatMap(this::addAliases);
    }

    private Stream<ConfigurationPropertyName> addAliases(ConfigurationPropertyName name2) {
        Stream<ConfigurationPropertyName> names2 = Stream.of(name2);
        List<ConfigurationPropertyName> aliases2 = this.getAliases().getAliases(name2);
        if (CollectionUtils.isEmpty(aliases2)) {
            return names2;
        }
        return Stream.concat(names2, aliases2.stream());
    }

    @Override
    protected IterableConfigurationPropertySource getSource() {
        return (IterableConfigurationPropertySource)super.getSource();
    }
}

