/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.util.Assert;

class AliasedConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource source;
    private final ConfigurationPropertyNameAliases aliases;

    AliasedConfigurationPropertySource(ConfigurationPropertySource source2, ConfigurationPropertyNameAliases aliases2) {
        Assert.notNull((Object)source2, "Source must not be null");
        Assert.notNull((Object)aliases2, "Aliases must not be null");
        this.source = source2;
        this.aliases = aliases2;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name2) {
        Assert.notNull((Object)name2, "Name must not be null");
        ConfigurationProperty result2 = this.getSource().getConfigurationProperty(name2);
        if (result2 == null) {
            ConfigurationPropertyName aliasedName = this.getAliases().getNameForAlias(name2);
            result2 = this.getSource().getConfigurationProperty(aliasedName);
        }
        return result2;
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name2) {
        Assert.notNull((Object)name2, "Name must not be null");
        ConfigurationPropertyState result2 = this.source.containsDescendantOf(name2);
        if (result2 != ConfigurationPropertyState.ABSENT) {
            return result2;
        }
        for (ConfigurationPropertyName alias : this.getAliases().getAliases(name2)) {
            ConfigurationPropertyState aliasResult = this.source.containsDescendantOf(alias);
            if (aliasResult == ConfigurationPropertyState.ABSENT) continue;
            return aliasResult;
        }
        for (ConfigurationPropertyName from : this.getAliases()) {
            for (ConfigurationPropertyName alias : this.getAliases().getAliases(from)) {
                if (!name2.isAncestorOf(alias) || this.source.getConfigurationProperty(from) == null) continue;
                return ConfigurationPropertyState.PRESENT;
            }
        }
        return ConfigurationPropertyState.ABSENT;
    }

    @Override
    public Object getUnderlyingSource() {
        return this.source.getUnderlyingSource();
    }

    protected ConfigurationPropertySource getSource() {
        return this.source;
    }

    protected ConfigurationPropertyNameAliases getAliases() {
        return this.aliases;
    }
}

