/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.bind.validation.OriginTrackedFieldError;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.Assert;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidationErrors
implements Iterable<ObjectError> {
    private final ConfigurationPropertyName name;
    private final Set<ConfigurationProperty> boundProperties;
    private final List<ObjectError> errors;

    ValidationErrors(ConfigurationPropertyName name2, Set<ConfigurationProperty> boundProperties, List<ObjectError> errors) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull(boundProperties, "BoundProperties must not be null");
        Assert.notNull(errors, "Errors must not be null");
        this.name = name2;
        this.boundProperties = Collections.unmodifiableSet(boundProperties);
        this.errors = this.convertErrors(name2, boundProperties, errors);
    }

    private List<ObjectError> convertErrors(ConfigurationPropertyName name2, Set<ConfigurationProperty> boundProperties, List<ObjectError> errors) {
        ArrayList<ObjectError> converted = new ArrayList<ObjectError>(errors.size());
        for (ObjectError error2 : errors) {
            converted.add(this.convertError(name2, boundProperties, error2));
        }
        return Collections.unmodifiableList(converted);
    }

    private ObjectError convertError(ConfigurationPropertyName name2, Set<ConfigurationProperty> boundProperties, ObjectError error2) {
        if (error2 instanceof FieldError) {
            FieldError fieldError = (FieldError)error2;
            return this.convertFieldError(name2, boundProperties, fieldError);
        }
        return error2;
    }

    private FieldError convertFieldError(ConfigurationPropertyName name2, Set<ConfigurationProperty> boundProperties, FieldError error2) {
        if (error2 instanceof OriginProvider) {
            return error2;
        }
        return OriginTrackedFieldError.of(error2, this.findFieldErrorOrigin(name2, boundProperties, error2));
    }

    private Origin findFieldErrorOrigin(ConfigurationPropertyName name2, Set<ConfigurationProperty> boundProperties, FieldError error2) {
        for (ConfigurationProperty boundProperty : boundProperties) {
            if (!this.isForError(name2, boundProperty.getName(), error2)) continue;
            return Origin.from(boundProperty);
        }
        return null;
    }

    private boolean isForError(ConfigurationPropertyName name2, ConfigurationPropertyName boundPropertyName, FieldError error2) {
        return name2.isParentOf(boundPropertyName) && boundPropertyName.getLastElement(ConfigurationPropertyName.Form.UNIFORM).equalsIgnoreCase(error2.getField());
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Set<ConfigurationProperty> getBoundProperties() {
        return this.boundProperties;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ObjectError> getAllErrors() {
        return this.errors;
    }

    @Override
    public Iterator<ObjectError> iterator() {
        return this.errors.iterator();
    }
}

