/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.validation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.DataObjectPropertyName;
import org.springframework.boot.context.properties.bind.validation.BindValidationException;
import org.springframework.boot.context.properties.bind.validation.ValidationErrors;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Validator;

public class ValidationBindHandler
extends AbstractBindHandler {
    private final Validator[] validators;
    private final Map<ConfigurationPropertyName, ResolvableType> boundTypes = new LinkedHashMap<ConfigurationPropertyName, ResolvableType>();
    private final Map<ConfigurationPropertyName, Object> boundResults = new LinkedHashMap<ConfigurationPropertyName, Object>();
    private final Set<ConfigurationProperty> boundProperties = new LinkedHashSet<ConfigurationProperty>();
    private BindValidationException exception;

    public ValidationBindHandler(Validator ... validators) {
        this.validators = validators;
    }

    public ValidationBindHandler(BindHandler parent, Validator ... validators) {
        super(parent);
        this.validators = validators;
    }

    @Override
    public <T> Bindable<T> onStart(ConfigurationPropertyName name2, Bindable<T> target2, BindContext context) {
        this.boundTypes.put(name2, target2.getType());
        return super.onStart(name2, target2, context);
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) {
        this.boundResults.put(name2, result2);
        if (context.getConfigurationProperty() != null) {
            this.boundProperties.add(context.getConfigurationProperty());
        }
        return super.onSuccess(name2, target2, context, result2);
    }

    @Override
    public Object onFailure(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Exception error2) throws Exception {
        Object result2 = super.onFailure(name2, target2, context, error2);
        if (result2 != null) {
            this.clear();
            this.boundResults.put(name2, result2);
        }
        this.validate(name2, target2, context, result2);
        return result2;
    }

    private void clear() {
        this.boundTypes.clear();
        this.boundResults.clear();
        this.boundProperties.clear();
        this.exception = null;
    }

    @Override
    public void onFinish(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) throws Exception {
        this.validate(name2, target2, context, result2);
        super.onFinish(name2, target2, context, result2);
    }

    private void validate(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) {
        if (this.exception == null) {
            Object validationTarget = this.getValidationTarget(target2, context, result2);
            Class<?> validationType = target2.getBoxedType().resolve();
            if (validationTarget != null) {
                this.validateAndPush(name2, validationTarget, validationType);
            }
        }
        if (context.getDepth() == 0 && this.exception != null) {
            throw this.exception;
        }
    }

    private Object getValidationTarget(Bindable<?> target2, BindContext context, Object result2) {
        if (result2 != null) {
            return result2;
        }
        if (context.getDepth() == 0 && target2.getValue() != null) {
            return target2.getValue().get();
        }
        return null;
    }

    private void validateAndPush(ConfigurationPropertyName name2, Object target2, Class<?> type2) {
        AbstractBindingResult result2 = null;
        for (Validator validator : this.validators) {
            if (!validator.supports(type2)) continue;
            result2 = result2 != null ? result2 : new ValidationResult(name2, target2);
            validator.validate(target2, result2);
        }
        if (result2 != null && result2.hasErrors()) {
            this.exception = new BindValidationException(((ValidationResult)result2).getValidationErrors());
        }
    }

    private class ValidationResult
    extends BeanPropertyBindingResult {
        private final ConfigurationPropertyName name;

        protected ValidationResult(ConfigurationPropertyName name2, Object target2) {
            super(target2, null);
            this.name = name2;
        }

        @Override
        public String getObjectName() {
            return this.name.toString();
        }

        @Override
        public Class<?> getFieldType(String field) {
            Class<?> resolved;
            ResolvableType type2 = this.getBoundField(ValidationBindHandler.this.boundTypes, field);
            Class<?> clazz = resolved = type2 != null ? type2.resolve() : null;
            if (resolved != null) {
                return resolved;
            }
            return super.getFieldType(field);
        }

        @Override
        protected Object getActualFieldValue(String field) {
            Object boundField = this.getBoundField(ValidationBindHandler.this.boundResults, field);
            if (boundField != null) {
                return boundField;
            }
            try {
                return super.getActualFieldValue(field);
            }
            catch (Exception ex) {
                if (this.isPropertyNotReadable(ex)) {
                    return null;
                }
                throw ex;
            }
        }

        private boolean isPropertyNotReadable(Throwable ex) {
            while (ex != null) {
                if (ex instanceof NotReadablePropertyException) {
                    return true;
                }
                ex = ex.getCause();
            }
            return false;
        }

        private <T> T getBoundField(Map<ConfigurationPropertyName, T> boundFields, String field) {
            try {
                ConfigurationPropertyName name2 = this.getName(field);
                T bound = boundFields.get(name2);
                if (bound != null) {
                    return bound;
                }
                if (name2.hasIndexedElement()) {
                    for (Map.Entry<ConfigurationPropertyName, T> entry : boundFields.entrySet()) {
                        if (!this.isFieldNameMatch(entry.getKey(), name2)) continue;
                        return entry.getValue();
                    }
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }

        private boolean isFieldNameMatch(ConfigurationPropertyName name2, ConfigurationPropertyName fieldName) {
            if (name2.getNumberOfElements() != fieldName.getNumberOfElements()) {
                return false;
            }
            for (int i2 = 0; i2 < name2.getNumberOfElements(); ++i2) {
                String fieldElement;
                String element = name2.getElement(i2, ConfigurationPropertyName.Form.ORIGINAL);
                if (ObjectUtils.nullSafeEquals(element, fieldElement = fieldName.getElement(i2, ConfigurationPropertyName.Form.ORIGINAL))) continue;
                return false;
            }
            return true;
        }

        private ConfigurationPropertyName getName(String field) {
            return this.name.append(DataObjectPropertyName.toDashedForm(field));
        }

        ValidationErrors getValidationErrors() {
            Set boundProperties = ValidationBindHandler.this.boundProperties.stream().filter(property -> this.name.isAncestorOf(property.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
            return new ValidationErrors(this.name, boundProperties, this.getAllErrors());
        }
    }
}

