/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.validation;

import org.springframework.boot.context.properties.bind.validation.ValidationErrors;
import org.springframework.util.Assert;

public class BindValidationException
extends RuntimeException {
    private final ValidationErrors validationErrors;

    BindValidationException(ValidationErrors validationErrors) {
        super(BindValidationException.getMessage(validationErrors));
        Assert.notNull((Object)validationErrors, "ValidationErrors must not be null");
        this.validationErrors = validationErrors;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    private static String getMessage(ValidationErrors errors) {
        StringBuilder message2 = new StringBuilder("Binding validation errors");
        if (errors != null) {
            message2.append(" on ").append(errors.getName());
            errors.getAllErrors().forEach(error2 -> message2.append(String.format("%n   - %s", error2)));
        }
        return message2.toString();
    }
}

