/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.handler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;

public class NoUnboundElementsBindHandler
extends AbstractBindHandler {
    private final Set<ConfigurationPropertyName> boundNames = new HashSet<ConfigurationPropertyName>();
    private final Set<ConfigurationPropertyName> attemptedNames = new HashSet<ConfigurationPropertyName>();
    private final Function<ConfigurationPropertySource, Boolean> filter;

    NoUnboundElementsBindHandler() {
        this(BindHandler.DEFAULT, configurationPropertySource -> true);
    }

    public NoUnboundElementsBindHandler(BindHandler parent) {
        this(parent, configurationPropertySource -> true);
    }

    public NoUnboundElementsBindHandler(BindHandler parent, Function<ConfigurationPropertySource, Boolean> filter2) {
        super(parent);
        this.filter = filter2;
    }

    @Override
    public <T> Bindable<T> onStart(ConfigurationPropertyName name2, Bindable<T> target2, BindContext context) {
        this.attemptedNames.add(name2);
        return super.onStart(name2, target2, context);
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) {
        this.boundNames.add(name2);
        return super.onSuccess(name2, target2, context, result2);
    }

    @Override
    public Object onFailure(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Exception error2) throws Exception {
        if (error2 instanceof UnboundConfigurationPropertiesException) {
            throw error2;
        }
        return super.onFailure(name2, target2, context, error2);
    }

    @Override
    public void onFinish(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) throws Exception {
        if (context.getDepth() == 0) {
            this.checkNoUnboundElements(name2, context);
        }
    }

    private void checkNoUnboundElements(ConfigurationPropertyName name2, BindContext context) {
        TreeSet<ConfigurationProperty> unbound = new TreeSet<ConfigurationProperty>();
        for (ConfigurationPropertySource source2 : context.getSources()) {
            if (!(source2 instanceof IterableConfigurationPropertySource) || !this.filter.apply(source2).booleanValue()) continue;
            this.collectUnbound(name2, unbound, (IterableConfigurationPropertySource)source2);
        }
        if (!unbound.isEmpty()) {
            throw new UnboundConfigurationPropertiesException(unbound);
        }
    }

    private void collectUnbound(ConfigurationPropertyName name2, Set<ConfigurationProperty> unbound, IterableConfigurationPropertySource source2) {
        ConfigurationPropertySource filtered = source2.filter(candidate -> this.isUnbound(name2, (ConfigurationPropertyName)candidate));
        Iterator<ConfigurationPropertyName> iterator = filtered.iterator();
        while (iterator.hasNext()) {
            ConfigurationPropertyName unboundName = iterator.next();
            try {
                unbound.add(source2.filter(candidate -> this.isUnbound(name2, (ConfigurationPropertyName)candidate)).getConfigurationProperty(unboundName));
            }
            catch (Exception exception2) {}
        }
    }

    private boolean isUnbound(ConfigurationPropertyName name2, ConfigurationPropertyName candidate) {
        if (name2.isAncestorOf(candidate)) {
            return !this.boundNames.contains(candidate) && !this.isOverriddenCollectionElement(candidate);
        }
        return false;
    }

    private boolean isOverriddenCollectionElement(ConfigurationPropertyName candidate) {
        String zeroethProperty;
        int lastIndex = candidate.getNumberOfElements() - 1;
        if (candidate.isLastElementIndexed()) {
            ConfigurationPropertyName propertyName = candidate.chop(lastIndex);
            return this.boundNames.contains(propertyName);
        }
        Indexed indexed = this.getIndexed(candidate);
        if (indexed != null && this.boundNames.contains(ConfigurationPropertyName.of(zeroethProperty = indexed.getName() + "[0]"))) {
            String nestedZeroethProperty = zeroethProperty + "." + indexed.getNestedPropertyName();
            return this.isCandidateValidPropertyName(nestedZeroethProperty);
        }
        return false;
    }

    private boolean isCandidateValidPropertyName(String nestedZeroethProperty) {
        return this.attemptedNames.contains(ConfigurationPropertyName.of(nestedZeroethProperty));
    }

    private Indexed getIndexed(ConfigurationPropertyName candidate) {
        for (int i2 = 0; i2 < candidate.getNumberOfElements(); ++i2) {
            if (!candidate.isNumericIndex(i2)) continue;
            return new Indexed(candidate.chop(i2).toString(), candidate.getElement(i2 + 1, ConfigurationPropertyName.Form.UNIFORM));
        }
        return null;
    }

    private static final class Indexed {
        private final String name;
        private final String nestedPropertyName;

        private Indexed(String name2, String nestedPropertyName) {
            this.name = name2;
            this.nestedPropertyName = nestedPropertyName;
        }

        String getName() {
            return this.name;
        }

        String getNestedPropertyName() {
            return this.nestedPropertyName;
        }
    }
}

