/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.BindConverter;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.DataObjectBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyName;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

class ValueObjectBinder
implements DataObjectBinder {
    private static final Log logger = LogFactory.getLog(ValueObjectBinder.class);
    private final BindConstructorProvider constructorProvider;

    ValueObjectBinder(BindConstructorProvider constructorProvider) {
        this.constructorProvider = constructorProvider;
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name2, Bindable<T> target2, Binder.Context context, DataObjectPropertyBinder propertyBinder) {
        ValueObject<T> valueObject = ValueObject.get(target2, this.constructorProvider, context, Discoverer.LENIENT);
        if (valueObject == null) {
            return null;
        }
        context.pushConstructorBoundTypes(target2.getType().resolve());
        List<ConstructorParameter> parameters2 = valueObject.getConstructorParameters();
        ArrayList<Object> args2 = new ArrayList<Object>(parameters2.size());
        boolean bound = false;
        for (ConstructorParameter parameter : parameters2) {
            Object arg2 = parameter.bind(propertyBinder);
            bound = bound || arg2 != null;
            arg2 = arg2 != null ? arg2 : this.getDefaultValue(context, parameter);
            args2.add(arg2);
        }
        context.clearConfigurationProperty();
        context.popConstructorBoundTypes();
        return bound ? (T)valueObject.instantiate(args2) : null;
    }

    @Override
    public <T> T create(Bindable<T> target2, Binder.Context context) {
        ValueObject<T> valueObject = ValueObject.get(target2, this.constructorProvider, context, Discoverer.LENIENT);
        if (valueObject == null) {
            return null;
        }
        List<ConstructorParameter> parameters2 = valueObject.getConstructorParameters();
        ArrayList<Object> args2 = new ArrayList<Object>(parameters2.size());
        for (ConstructorParameter parameter : parameters2) {
            args2.add(this.getDefaultValue(context, parameter));
        }
        return valueObject.instantiate(args2);
    }

    @Override
    public <T> void onUnableToCreateInstance(Bindable<T> target2, Binder.Context context, RuntimeException exception2) {
        try {
            ValueObject.get(target2, this.constructorProvider, context, Discoverer.STRICT);
        }
        catch (Exception ex) {
            exception2.addSuppressed(ex);
        }
    }

    private <T> T getDefaultValue(Binder.Context context, ConstructorParameter parameter) {
        Annotation[] annotations;
        ResolvableType type2 = parameter.getType();
        for (Annotation annotation : annotations = parameter.getAnnotations()) {
            if (!(annotation instanceof DefaultValue)) continue;
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            String[] defaultValue = defaultValueAnnotation.value();
            if (defaultValue.length == 0) {
                return this.getNewDefaultValueInstanceIfPossible(context, type2);
            }
            return this.convertDefaultValue(context.getConverter(), defaultValue, type2, annotations);
        }
        return null;
    }

    private <T> T convertDefaultValue(BindConverter converter, String[] defaultValue, ResolvableType type2, Annotation[] annotations) {
        try {
            return converter.convert((Object)defaultValue, type2, annotations);
        }
        catch (ConversionException ex) {
            if (defaultValue.length == 1) {
                return converter.convert((Object)defaultValue[0], type2, annotations);
            }
            throw ex;
        }
    }

    private <T> T getNewDefaultValueInstanceIfPossible(Binder.Context context, ResolvableType type2) {
        Object instance;
        Class<?> resolved = type2.resolve();
        Assert.state(resolved == null || this.isEmptyDefaultValueAllowed(resolved), () -> "Parameter of type " + type2 + " must have a non-empty default value.");
        if (resolved != null) {
            if (Optional.class == resolved) {
                return (T)Optional.empty();
            }
            if (Collection.class.isAssignableFrom(resolved)) {
                return (T)CollectionFactory.createCollection(resolved, 0);
            }
            if (EnumMap.class.isAssignableFrom(resolved)) {
                Class<?> keyType = type2.asMap().resolveGeneric(0);
                return (T)CollectionFactory.createMap(resolved, keyType, 0);
            }
            if (Map.class.isAssignableFrom(resolved)) {
                return (T)CollectionFactory.createMap(resolved, 0);
            }
            if (resolved.isArray()) {
                return (T)Array.newInstance(resolved.getComponentType(), 0);
            }
        }
        if ((instance = this.create(Bindable.of(type2), context)) != null) {
            return instance;
        }
        return resolved != null ? (T)BeanUtils.instantiateClass(resolved) : null;
    }

    private boolean isEmptyDefaultValueAllowed(Class<?> type2) {
        return Optional.class == type2 || this.isAggregate(type2) || !type2.isPrimitive() && !type2.isEnum() && !type2.getName().startsWith("java.lang");
    }

    private boolean isAggregate(Class<?> type2) {
        return type2.isArray() || Map.class.isAssignableFrom(type2) || Collection.class.isAssignableFrom(type2);
    }

    static final class Discoverer
    implements ParameterNameDiscoverer {
        private static final ParameterNameDiscoverer DEFAULT_DELEGATE = new DefaultParameterNameDiscoverer();
        private static final ParameterNameDiscoverer LENIENT = new Discoverer(DEFAULT_DELEGATE, message2 -> {});
        private static final ParameterNameDiscoverer STRICT = new Discoverer(DEFAULT_DELEGATE, message2 -> {
            throw new IllegalStateException(message2.toString());
        });
        private final ParameterNameDiscoverer delegate;
        private final Consumer<LogMessage> noParameterNamesHandler;

        private Discoverer(ParameterNameDiscoverer delegate, Consumer<LogMessage> noParameterNamesHandler) {
            this.delegate = delegate;
            this.noParameterNamesHandler = noParameterNamesHandler;
        }

        @Override
        public String[] getParameterNames(Method method2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getParameterNames(Constructor<?> constructor2) {
            String[] names2 = this.delegate.getParameterNames(constructor2);
            if (names2 != null) {
                return names2;
            }
            LogMessage message2 = LogMessage.format("Unable to use value object binding with constructor [%s] as parameter names cannot be discovered. Ensure that the compiler uses the '-parameters' flag", constructor2);
            this.noParameterNamesHandler.accept(message2);
            logger.debug(message2);
            return null;
        }
    }

    private static abstract class ValueObject<T> {
        private final Constructor<T> constructor;

        protected ValueObject(Constructor<T> constructor2) {
            this.constructor = constructor2;
        }

        T instantiate(List<Object> args2) {
            return BeanUtils.instantiateClass(this.constructor, args2.toArray());
        }

        abstract List<ConstructorParameter> getConstructorParameters();

        static <T> ValueObject<T> get(Bindable<T> bindable, BindConstructorProvider constructorProvider, Binder.Context context, ParameterNameDiscoverer parameterNameDiscoverer) {
            Class<?> type2 = bindable.getType().resolve();
            if (type2 == null || type2.isEnum() || Modifier.isAbstract(type2.getModifiers())) {
                return null;
            }
            Constructor<?> bindConstructor = constructorProvider.getBindConstructor(bindable, context.isNestedConstructorBinding());
            if (bindConstructor == null) {
                return null;
            }
            if (KotlinDetector.isKotlinType(type2)) {
                return KotlinValueObject.get(bindConstructor, bindable.getType(), parameterNameDiscoverer);
            }
            return DefaultValueObject.get(bindConstructor, bindable.getType(), parameterNameDiscoverer);
        }
    }

    private static class ConstructorParameter {
        private final String name;
        private final ResolvableType type;
        private final Annotation[] annotations;

        ConstructorParameter(String name2, ResolvableType type2, Annotation[] annotations) {
            this.name = DataObjectPropertyName.toDashedForm(name2);
            this.type = type2;
            this.annotations = annotations;
        }

        Object bind(DataObjectPropertyBinder propertyBinder) {
            return propertyBinder.bindProperty(this.name, Bindable.of(this.type).withAnnotations(this.annotations));
        }

        Annotation[] getAnnotations() {
            return this.annotations;
        }

        ResolvableType getType() {
            return this.type;
        }
    }

    private static final class DefaultValueObject<T>
    extends ValueObject<T> {
        private final List<ConstructorParameter> constructorParameters;

        private DefaultValueObject(Constructor<T> constructor2, List<ConstructorParameter> constructorParameters) {
            super(constructor2);
            this.constructorParameters = constructorParameters;
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> ValueObject<T> get(Constructor<?> bindConstructor, ResolvableType type2, ParameterNameDiscoverer parameterNameDiscoverer) {
            String[] names2 = parameterNameDiscoverer.getParameterNames(bindConstructor);
            if (names2 == null) {
                return null;
            }
            List<ConstructorParameter> constructorParameters = DefaultValueObject.parseConstructorParameters(bindConstructor, type2, names2);
            return new DefaultValueObject(bindConstructor, constructorParameters);
        }

        private static List<ConstructorParameter> parseConstructorParameters(Constructor<?> constructor2, ResolvableType type2, String[] names2) {
            Parameter[] parameters2 = constructor2.getParameters();
            ArrayList<ConstructorParameter> result2 = new ArrayList<ConstructorParameter>(parameters2.length);
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                String name2 = MergedAnnotations.from(parameters2[i2]).get(Name.class).getValue("value", String.class).orElse(names2[i2]);
                ResolvableType parameterType = ResolvableType.forMethodParameter(new MethodParameter(constructor2, i2), type2);
                Annotation[] annotations = parameters2[i2].getDeclaredAnnotations();
                result2.add(new ConstructorParameter(name2, parameterType, annotations));
            }
            return Collections.unmodifiableList(result2);
        }
    }

    private static final class KotlinValueObject<T>
    extends ValueObject<T> {
        private static final Annotation[] ANNOTATION_ARRAY = new Annotation[0];
        private final List<ConstructorParameter> constructorParameters;

        private KotlinValueObject(Constructor<T> primaryConstructor, KFunction<T> kotlinConstructor, ResolvableType type2) {
            super(primaryConstructor);
            this.constructorParameters = this.parseConstructorParameters(kotlinConstructor, type2);
        }

        private List<ConstructorParameter> parseConstructorParameters(KFunction<T> kotlinConstructor, ResolvableType type2) {
            List parameters2 = kotlinConstructor.getParameters();
            ArrayList<ConstructorParameter> result2 = new ArrayList<ConstructorParameter>(parameters2.size());
            for (KParameter parameter : parameters2) {
                String name2 = this.getParameterName(parameter);
                ResolvableType parameterType = ResolvableType.forType(ReflectJvmMapping.getJavaType((KType)parameter.getType()), type2);
                Annotation[] annotations = parameter.getAnnotations().toArray(ANNOTATION_ARRAY);
                result2.add(new ConstructorParameter(name2, parameterType, annotations));
            }
            return Collections.unmodifiableList(result2);
        }

        private String getParameterName(KParameter parameter) {
            return MergedAnnotations.from((Object)parameter, parameter.getAnnotations().toArray(ANNOTATION_ARRAY)).get(Name.class).getValue("value", String.class).orElseGet(() -> ((KParameter)parameter).getName());
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> ValueObject<T> get(Constructor<T> bindConstructor, ResolvableType type2, ParameterNameDiscoverer parameterNameDiscoverer) {
            KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction(bindConstructor);
            if (kotlinConstructor != null) {
                return new KotlinValueObject<T>(bindConstructor, kotlinConstructor, type2);
            }
            return DefaultValueObject.get(bindConstructor, type2, parameterNameDiscoverer);
        }
    }
}

