/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertySourcesPlaceholdersResolver
implements PlaceholdersResolver {
    private final Iterable<PropertySource<?>> sources;
    private final PropertyPlaceholderHelper helper;

    public PropertySourcesPlaceholdersResolver(Environment environment2) {
        this(PropertySourcesPlaceholdersResolver.getSources(environment2), null);
    }

    public PropertySourcesPlaceholdersResolver(Iterable<PropertySource<?>> sources) {
        this(sources, null);
    }

    public PropertySourcesPlaceholdersResolver(Iterable<PropertySource<?>> sources, PropertyPlaceholderHelper helper) {
        this.sources = sources;
        this.helper = helper != null ? helper : new PropertyPlaceholderHelper("${", "}", ":", true);
    }

    @Override
    public Object resolvePlaceholders(Object value2) {
        if (value2 instanceof String) {
            String string2 = (String)value2;
            return this.helper.replacePlaceholders(string2, this::resolvePlaceholder);
        }
        return value2;
    }

    protected String resolvePlaceholder(String placeholder) {
        if (this.sources != null) {
            for (PropertySource<?> source2 : this.sources) {
                Object value2 = source2.getProperty(placeholder);
                if (value2 == null) continue;
                return String.valueOf(value2);
            }
        }
        return null;
    }

    private static PropertySources getSources(Environment environment2) {
        Assert.notNull((Object)environment2, "Environment must not be null");
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment2, "Environment must be a ConfigurableEnvironment");
        return ((ConfigurableEnvironment)environment2).getPropertySources();
    }
}

