/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class MapBinder
extends AggregateBinder<Map<Object, Object>> {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);

    MapBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected boolean isAllowRecursiveBinding(ConfigurationPropertySource source2) {
        return true;
    }

    @Override
    protected Object bindAggregate(ConfigurationPropertyName name2, Bindable<?> target2, AggregateElementBinder elementBinder) {
        Bindable<?> resolvedTarget = this.resolveTarget(target2);
        boolean hasDescendants = this.hasDescendants(name2);
        if (!hasDescendants && !ConfigurationPropertyName.EMPTY.equals(name2)) {
            for (ConfigurationPropertySource source2 : this.getContext().getSources()) {
                ConfigurationProperty property = source2.getConfigurationProperty(name2);
                if (property == null) continue;
                this.getContext().setConfigurationProperty(property);
                Object result2 = this.getContext().getPlaceholdersResolver().resolvePlaceholders(property.getValue());
                return this.getContext().getConverter().convert(result2, target2);
            }
        }
        Map<Object, Object> map2 = this.createMap(target2);
        for (ConfigurationPropertySource source3 : this.getContext().getSources()) {
            if (!ConfigurationPropertyName.EMPTY.equals(name2)) {
                source3 = source3.filter(name2::isAncestorOf);
            }
            new EntryBinder(name2, resolvedTarget, elementBinder).bindEntries(source3, map2);
        }
        return map2.isEmpty() ? null : map2;
    }

    private Map<Object, Object> createMap(Bindable<?> target2) {
        Class<Map> mapType;
        Class clazz = mapType = target2.getValue() != null ? Map.class : target2.getType().resolve(Object.class);
        if (EnumMap.class.isAssignableFrom(mapType)) {
            Class<?> keyType = target2.getType().asMap().resolveGeneric(0);
            return CollectionFactory.createMap(mapType, keyType, 0);
        }
        return CollectionFactory.createMap(mapType, 0);
    }

    private boolean hasDescendants(ConfigurationPropertyName name2) {
        for (ConfigurationPropertySource source2 : this.getContext().getSources()) {
            if (source2.containsDescendantOf(name2) != ConfigurationPropertyState.PRESENT) continue;
            return true;
        }
        return false;
    }

    private Bindable<?> resolveTarget(Bindable<?> target2) {
        Class<?> type2 = target2.getType().resolve(Object.class);
        if (Properties.class.isAssignableFrom(type2)) {
            return STRING_STRING_MAP;
        }
        return target2;
    }

    @Override
    protected Map<Object, Object> merge(Supplier<Map<Object, Object>> existing, Map<Object, Object> additional) {
        Map<Object, Object> existingMap = this.getExistingIfPossible(existing);
        if (existingMap == null) {
            return additional;
        }
        try {
            existingMap.putAll(additional);
            return this.copyIfPossible(existingMap);
        }
        catch (UnsupportedOperationException ex) {
            Map<Object, Object> result2 = this.createNewMap(additional.getClass(), existingMap);
            result2.putAll(additional);
            return result2;
        }
    }

    private Map<Object, Object> getExistingIfPossible(Supplier<Map<Object, Object>> existing) {
        try {
            return existing.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Map<Object, Object> copyIfPossible(Map<Object, Object> map2) {
        try {
            return this.createNewMap(map2.getClass(), map2);
        }
        catch (Exception ex) {
            return map2;
        }
    }

    private Map<Object, Object> createNewMap(Class<?> mapClass, Map<Object, Object> map2) {
        Map<Object, Object> result2 = CollectionFactory.createMap(mapClass, map2.size());
        result2.putAll(map2);
        return result2;
    }

    private class EntryBinder {
        private final ConfigurationPropertyName root;
        private final AggregateElementBinder elementBinder;
        private final ResolvableType mapType;
        private final ResolvableType keyType;
        private final ResolvableType valueType;

        EntryBinder(ConfigurationPropertyName root, Bindable<?> target2, AggregateElementBinder elementBinder) {
            this.root = root;
            this.elementBinder = elementBinder;
            this.mapType = target2.getType().asMap();
            this.keyType = this.mapType.getGeneric(0);
            this.valueType = this.mapType.getGeneric(1);
        }

        void bindEntries(ConfigurationPropertySource source2, Map<Object, Object> map2) {
            if (source2 instanceof IterableConfigurationPropertySource) {
                IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)source2;
                for (ConfigurationPropertyName name2 : iterableSource) {
                    Bindable<?> valueBindable = this.getValueBindable(name2);
                    ConfigurationPropertyName entryName = this.getEntryName(source2, name2);
                    Object key2 = MapBinder.this.getContext().getConverter().convert((Object)this.getKeyName(entryName), this.keyType, new Annotation[0]);
                    map2.computeIfAbsent(key2, k -> this.elementBinder.bind(entryName, valueBindable));
                }
            }
        }

        private Bindable<?> getValueBindable(ConfigurationPropertyName name2) {
            if (!this.root.isParentOf(name2) && this.isValueTreatedAsNestedMap()) {
                return Bindable.of(this.mapType);
            }
            return Bindable.of(this.valueType);
        }

        private ConfigurationPropertyName getEntryName(ConfigurationPropertySource source2, ConfigurationPropertyName name2) {
            Class<?> resolved = this.valueType.resolve(Object.class);
            if (Collection.class.isAssignableFrom(resolved) || this.valueType.isArray()) {
                return this.chopNameAtNumericIndex(name2);
            }
            if (!(this.root.isParentOf(name2) || !this.isValueTreatedAsNestedMap() && this.isScalarValue(source2, name2))) {
                return name2.chop(this.root.getNumberOfElements() + 1);
            }
            return name2;
        }

        private ConfigurationPropertyName chopNameAtNumericIndex(ConfigurationPropertyName name2) {
            int start2 = this.root.getNumberOfElements() + 1;
            int size2 = name2.getNumberOfElements();
            for (int i2 = start2; i2 < size2; ++i2) {
                if (!name2.isNumericIndex(i2)) continue;
                return name2.chop(i2);
            }
            return name2;
        }

        private boolean isValueTreatedAsNestedMap() {
            return Object.class.equals(this.valueType.resolve(Object.class));
        }

        private boolean isScalarValue(ConfigurationPropertySource source2, ConfigurationPropertyName name2) {
            Class<?> resolved = this.valueType.resolve(Object.class);
            if (!resolved.getName().startsWith("java.lang") && !resolved.isEnum()) {
                return false;
            }
            ConfigurationProperty property = source2.getConfigurationProperty(name2);
            if (property == null) {
                return false;
            }
            Object value2 = property.getValue();
            value2 = MapBinder.this.getContext().getPlaceholdersResolver().resolvePlaceholders(value2);
            return MapBinder.this.getContext().getConverter().canConvert(value2, this.valueType, new Annotation[0]);
        }

        private String getKeyName(ConfigurationPropertyName name2) {
            StringBuilder result2 = new StringBuilder();
            for (int i2 = this.root.getNumberOfElements(); i2 < name2.getNumberOfElements(); ++i2) {
                if (!result2.isEmpty()) {
                    result2.append('.');
                }
                result2.append(name2.getElement(i2, ConfigurationPropertyName.Form.ORIGINAL));
            }
            return result2.toString();
        }
    }
}

