/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.DataObjectBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;

class JavaBeanBinder
implements DataObjectBinder {
    static final JavaBeanBinder INSTANCE = new JavaBeanBinder();

    JavaBeanBinder() {
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name2, Bindable<T> target2, Binder.Context context, DataObjectPropertyBinder propertyBinder) {
        boolean hasKnownBindableProperties = target2.getValue() != null && this.hasKnownBindableProperties(name2, context);
        Bean<T> bean2 = Bean.get(target2, hasKnownBindableProperties);
        if (bean2 == null) {
            return null;
        }
        BeanSupplier<T> beanSupplier = bean2.getSupplier(target2);
        boolean bound = this.bind(propertyBinder, bean2, beanSupplier, context);
        return bound ? (T)beanSupplier.get() : null;
    }

    @Override
    public <T> T create(Bindable<T> target2, Binder.Context context) {
        Class<?> type2 = target2.getType().resolve();
        return type2 != null ? (T)BeanUtils.instantiateClass(type2) : null;
    }

    private boolean hasKnownBindableProperties(ConfigurationPropertyName name2, Binder.Context context) {
        for (ConfigurationPropertySource source2 : context.getSources()) {
            if (source2.containsDescendantOf(name2) != ConfigurationPropertyState.PRESENT) continue;
            return true;
        }
        return false;
    }

    private <T> boolean bind(DataObjectPropertyBinder propertyBinder, Bean<T> bean2, BeanSupplier<T> beanSupplier, Binder.Context context) {
        boolean bound = false;
        for (BeanProperty beanProperty : bean2.getProperties().values()) {
            bound |= this.bind(beanSupplier, propertyBinder, beanProperty);
            context.clearConfigurationProperty();
        }
        return bound;
    }

    private <T> boolean bind(BeanSupplier<T> beanSupplier, DataObjectPropertyBinder propertyBinder, BeanProperty property) {
        String propertyName = property.getName();
        ResolvableType type2 = property.getType();
        Supplier<Object> value2 = property.getValue(beanSupplier);
        Annotation[] annotations = property.getAnnotations();
        Object bound = propertyBinder.bindProperty(propertyName, Bindable.of(type2).withSuppliedValue(value2).withAnnotations(annotations));
        if (bound == null) {
            return false;
        }
        if (property.isSettable()) {
            property.setValue(beanSupplier, bound);
        } else if (value2 == null || !bound.equals(value2.get())) {
            throw new IllegalStateException("No setter found for property: " + property.getName());
        }
        return true;
    }

    static class Bean<T>
    extends BeanProperties {
        private static Bean<?> cached;

        Bean(ResolvableType type2, Class<?> resolvedType) {
            super(type2, resolvedType);
        }

        BeanSupplier<T> getSupplier(Bindable<T> target2) {
            return new BeanSupplier<Object>(() -> {
                Object instance = null;
                if (target2.getValue() != null) {
                    instance = target2.getValue().get();
                }
                if (instance == null) {
                    instance = BeanUtils.instantiateClass(this.getResolvedType());
                }
                return instance;
            });
        }

        static <T> Bean<T> get(Bindable<T> bindable, boolean canCallGetValue) {
            ResolvableType type2 = bindable.getType();
            Class<?> resolvedType = type2.resolve(Object.class);
            Supplier<T> value2 = bindable.getValue();
            Object instance = null;
            if (canCallGetValue && value2 != null) {
                instance = value2.get();
                Class<?> clazz = resolvedType = instance != null ? instance.getClass() : resolvedType;
            }
            if (instance == null && !Bean.isInstantiable(resolvedType)) {
                return null;
            }
            Bean<Object> bean2 = cached;
            if (bean2 == null || !bean2.isOfType(type2, resolvedType)) {
                bean2 = new Bean<T>(type2, resolvedType);
                cached = bean2;
            }
            return bean2;
        }

        private static boolean isInstantiable(Class<?> type2) {
            if (type2.isInterface()) {
                return false;
            }
            try {
                type2.getDeclaredConstructor(new Class[0]);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        private boolean isOfType(ResolvableType type2, Class<?> resolvedType) {
            if (this.getType().hasGenerics() || type2.hasGenerics()) {
                return this.getType().equals(type2);
            }
            return this.getResolvedType() != null && this.getResolvedType().equals(resolvedType);
        }
    }

    private static class BeanSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> factory;
        private T instance;

        BeanSupplier(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                this.instance = this.factory.get();
            }
            return this.instance;
        }
    }

    static class BeanProperty {
        private final String name;
        private final ResolvableType declaringClassType;
        private Method getter;
        private Method setter;
        private Field field;

        BeanProperty(String name2, ResolvableType declaringClassType) {
            this.name = DataObjectPropertyName.toDashedForm(name2);
            this.declaringClassType = declaringClassType;
        }

        void addGetter(Method getter) {
            if (this.getter == null || this.getter.getName().startsWith("is")) {
                this.getter = getter;
            }
        }

        void addSetter(Method setter) {
            if (this.setter == null || this.isBetterSetter(setter)) {
                this.setter = setter;
            }
        }

        private boolean isBetterSetter(Method setter) {
            return this.getter != null && this.getter.getReturnType().equals(setter.getParameterTypes()[0]);
        }

        void addField(Field field) {
            if (this.field == null) {
                this.field = field;
            }
        }

        String getName() {
            return this.name;
        }

        ResolvableType getType() {
            if (this.setter != null) {
                MethodParameter methodParameter = new MethodParameter(this.setter, 0);
                return ResolvableType.forMethodParameter(methodParameter, this.declaringClassType);
            }
            MethodParameter methodParameter = new MethodParameter(this.getter, -1);
            return ResolvableType.forMethodParameter(methodParameter, this.declaringClassType);
        }

        Annotation[] getAnnotations() {
            try {
                return this.field != null ? this.field.getDeclaredAnnotations() : null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        Supplier<Object> getValue(Supplier<?> instance) {
            if (this.getter == null) {
                return null;
            }
            return () -> {
                try {
                    this.getter.setAccessible(true);
                    return this.getter.invoke(instance.get(), new Object[0]);
                }
                catch (Exception ex) {
                    if (this.isUninitializedKotlinProperty(ex)) {
                        return null;
                    }
                    throw new IllegalStateException("Unable to get value for property " + this.name, ex);
                }
            };
        }

        private boolean isUninitializedKotlinProperty(Exception ex) {
            InvocationTargetException invocationTargetException;
            return ex instanceof InvocationTargetException && "kotlin.UninitializedPropertyAccessException".equals((invocationTargetException = (InvocationTargetException)ex).getTargetException().getClass().getName());
        }

        boolean isSettable() {
            return this.setter != null;
        }

        void setValue(Supplier<?> instance, Object value2) {
            try {
                this.setter.setAccessible(true);
                this.setter.invoke(instance.get(), value2);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to set value for property " + this.name, ex);
            }
        }

        Method getGetter() {
            return this.getter;
        }

        Method getSetter() {
            return this.setter;
        }
    }

    static class BeanProperties {
        private final Map<String, BeanProperty> properties = new LinkedHashMap<String, BeanProperty>();
        private final ResolvableType type;
        private final Class<?> resolvedType;

        BeanProperties(ResolvableType type2, Class<?> resolvedType) {
            this.type = type2;
            this.resolvedType = resolvedType;
            this.addProperties(resolvedType);
        }

        private void addProperties(Class<?> type2) {
            while (type2 != null && !Object.class.equals(type2)) {
                Method[] declaredMethods = this.getSorted(type2, this::getDeclaredMethods, Method::getName);
                Field[] declaredFields = this.getSorted(type2, Class::getDeclaredFields, Field::getName);
                this.addProperties(declaredMethods, declaredFields);
                type2 = type2.getSuperclass();
            }
        }

        private Method[] getDeclaredMethods(Class<?> type2) {
            Method[] methods2 = type2.getDeclaredMethods();
            LinkedHashSet<Method> result2 = new LinkedHashSet<Method>(methods2.length);
            for (Method method2 : methods2) {
                result2.add(BridgeMethodResolver.findBridgedMethod(method2));
            }
            return result2.toArray(new Method[0]);
        }

        private <S, E> E[] getSorted(S source2, Function<S, E[]> elements, Function<E, String> name2) {
            E[] result2 = elements.apply(source2);
            Arrays.sort(result2, Comparator.comparing(name2));
            return result2;
        }

        protected void addProperties(Method[] declaredMethods, Field[] declaredFields) {
            for (int i2 = 0; i2 < declaredMethods.length; ++i2) {
                if (this.isCandidate(declaredMethods[i2])) continue;
                declaredMethods[i2] = null;
            }
            for (Method method2 : declaredMethods) {
                this.addMethodIfPossible(method2, "is", 0, BeanProperty::addGetter);
            }
            for (Method method3 : declaredMethods) {
                this.addMethodIfPossible(method3, "get", 0, BeanProperty::addGetter);
            }
            for (Method method4 : declaredMethods) {
                this.addMethodIfPossible(method4, "set", 1, BeanProperty::addSetter);
            }
            for (AccessibleObject accessibleObject : declaredFields) {
                this.addField((Field)accessibleObject);
            }
        }

        private boolean isCandidate(Method method2) {
            int modifiers = method2.getModifiers();
            return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers) && !method2.isBridge() && !Object.class.equals(method2.getDeclaringClass()) && !Class.class.equals(method2.getDeclaringClass()) && method2.getName().indexOf(36) == -1;
        }

        private void addMethodIfPossible(Method method2, String prefix, int parameterCount, BiConsumer<BeanProperty, Method> consumer) {
            if (method2 != null && method2.getParameterCount() == parameterCount && method2.getName().startsWith(prefix) && method2.getName().length() > prefix.length()) {
                String propertyName = Introspector.decapitalize(method2.getName().substring(prefix.length()));
                consumer.accept(this.properties.computeIfAbsent(propertyName, this::getBeanProperty), method2);
            }
        }

        private BeanProperty getBeanProperty(String name2) {
            return new BeanProperty(name2, this.type);
        }

        private void addField(Field field) {
            BeanProperty property = this.properties.get(field.getName());
            if (property != null) {
                property.addField(field);
            }
        }

        protected final ResolvableType getType() {
            return this.type;
        }

        protected final Class<?> getResolvedType() {
            return this.resolvedType;
        }

        final Map<String, BeanProperty> getProperties() {
            return this.properties;
        }

        static BeanProperties of(Bindable<?> bindable) {
            ResolvableType type2 = bindable.getType();
            Class<?> resolvedType = type2.resolve(Object.class);
            return new BeanProperties(type2, resolvedType);
        }
    }
}

