/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.ResolvableType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

abstract class IndexedElementsBinder<T>
extends AggregateBinder<T> {
    private static final String INDEX_ZERO = "[0]";

    IndexedElementsBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected boolean isAllowRecursiveBinding(ConfigurationPropertySource source2) {
        return source2 == null || source2 instanceof IterableConfigurationPropertySource;
    }

    protected final void bindIndexed(ConfigurationPropertyName name2, Bindable<?> target2, AggregateElementBinder elementBinder, ResolvableType aggregateType, ResolvableType elementType, IndexedCollectionSupplier result2) {
        for (ConfigurationPropertySource source2 : this.getContext().getSources()) {
            this.bindIndexed(source2, name2, target2, elementBinder, result2, aggregateType, elementType);
            if (!result2.wasSupplied() || result2.get() == null) continue;
            return;
        }
    }

    private void bindIndexed(ConfigurationPropertySource source2, ConfigurationPropertyName root, Bindable<?> target2, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType aggregateType, ResolvableType elementType) {
        ConfigurationProperty property = source2.getConfigurationProperty(root);
        if (property != null) {
            this.getContext().setConfigurationProperty(property);
            this.bindValue(target2, (Collection)collection.get(), aggregateType, elementType, property.getValue());
        } else {
            this.bindIndexed(source2, root, elementBinder, collection, elementType);
        }
    }

    private void bindValue(Bindable<?> target2, Collection<Object> collection, ResolvableType aggregateType, ResolvableType elementType, Object value2) {
        CharSequence charSequence;
        if (value2 == null || value2 instanceof CharSequence && (charSequence = (CharSequence)value2).isEmpty()) {
            return;
        }
        Object aggregate = this.convert(value2, aggregateType, target2.getAnnotations());
        ResolvableType collectionType = ResolvableType.forClassWithGenerics(collection.getClass(), elementType);
        Collection elements = (Collection)this.convert(aggregate, collectionType, new Annotation[0]);
        collection.addAll(elements);
    }

    private void bindIndexed(ConfigurationPropertySource source2, ConfigurationPropertyName root, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType elementType) {
        ConfigurationPropertyName name2;
        Object value2;
        MultiValueMap<String, ConfigurationPropertyName> knownIndexedChildren = this.getKnownIndexedChildren(source2, root);
        for (int i2 = 0; i2 < Integer.MAX_VALUE && (value2 = elementBinder.bind(name2 = root.append((String)(i2 != 0 ? "[" + i2 + "]" : INDEX_ZERO)), Bindable.of(elementType), source2)) != null; ++i2) {
            knownIndexedChildren.remove(name2.getLastElement(ConfigurationPropertyName.Form.UNIFORM));
            ((Collection)collection.get()).add(value2);
        }
        this.assertNoUnboundChildren(source2, knownIndexedChildren);
    }

    private MultiValueMap<String, ConfigurationPropertyName> getKnownIndexedChildren(ConfigurationPropertySource source2, ConfigurationPropertyName root) {
        LinkedMultiValueMap<String, ConfigurationPropertyName> children2 = new LinkedMultiValueMap<String, ConfigurationPropertyName>();
        if (!(source2 instanceof IterableConfigurationPropertySource)) {
            return children2;
        }
        IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)source2;
        Iterator<ConfigurationPropertyName> iterator = iterableSource.filter(root::isAncestorOf).iterator();
        while (iterator.hasNext()) {
            ConfigurationPropertyName name2 = iterator.next();
            ConfigurationPropertyName choppedName = name2.chop(root.getNumberOfElements() + 1);
            if (!choppedName.isLastElementIndexed()) continue;
            String key2 = choppedName.getLastElement(ConfigurationPropertyName.Form.UNIFORM);
            children2.add(key2, name2);
        }
        return children2;
    }

    private void assertNoUnboundChildren(ConfigurationPropertySource source2, MultiValueMap<String, ConfigurationPropertyName> children2) {
        if (!children2.isEmpty()) {
            throw new UnboundConfigurationPropertiesException(children2.values().stream().flatMap(Collection::stream).map(source2::getConfigurationProperty).collect(Collectors.toCollection(TreeSet::new)));
        }
    }

    private <C> C convert(Object value2, ResolvableType type2, Annotation ... annotations) {
        value2 = this.getContext().getPlaceholdersResolver().resolvePlaceholders(value2);
        return (C)this.getContext().getConverter().convert(value2, type2, annotations);
    }

    protected static class IndexedCollectionSupplier
    extends AggregateBinder.AggregateSupplier<Collection<Object>> {
        public IndexedCollectionSupplier(Supplier<Collection<Object>> supplier) {
            super(supplier);
        }
    }
}

