/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.core.KotlinDetector;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class DefaultBindConstructorProvider
implements BindConstructorProvider {
    DefaultBindConstructorProvider() {
    }

    @Override
    public Constructor<?> getBindConstructor(Bindable<?> bindable, boolean isNestedConstructorBinding) {
        Constructors constructors2 = Constructors.getConstructors(bindable.getType().resolve(), isNestedConstructorBinding);
        if (constructors2.getBind() != null && constructors2.isDeducedBindConstructor() && !constructors2.isImmutableType() && bindable.getValue() != null && bindable.getValue().get() != null) {
            return null;
        }
        return constructors2.getBind();
    }

    @Override
    public Constructor<?> getBindConstructor(Class<?> type2, boolean isNestedConstructorBinding) {
        Constructors constructors2 = Constructors.getConstructors(type2, isNestedConstructorBinding);
        return constructors2.getBind();
    }

    static final class Constructors {
        private static final Constructors NONE = new Constructors(false, null, false, false);
        private final boolean hasAutowired;
        private final Constructor<?> bind;
        private final boolean deducedBindConstructor;
        private final boolean immutableType;

        private Constructors(boolean hasAutowired, Constructor<?> bind2, boolean deducedBindConstructor, boolean immutableType) {
            this.hasAutowired = hasAutowired;
            this.bind = bind2;
            this.deducedBindConstructor = deducedBindConstructor;
            this.immutableType = immutableType;
        }

        boolean hasAutowired() {
            return this.hasAutowired;
        }

        Constructor<?> getBind() {
            return this.bind;
        }

        boolean isDeducedBindConstructor() {
            return this.deducedBindConstructor;
        }

        boolean isImmutableType() {
            return this.immutableType;
        }

        static Constructors getConstructors(Class<?> type2, boolean isNestedConstructorBinding) {
            if (type2 == null) {
                return NONE;
            }
            boolean hasAutowiredConstructor = Constructors.isAutowiredPresent(type2);
            Constructor<?>[] candidates = Constructors.getCandidateConstructors(type2);
            MergedAnnotations[] candidateAnnotations = Constructors.getAnnotations(candidates);
            boolean deducedBindConstructor = false;
            boolean immutableType = type2.isRecord();
            Constructor<?> bind2 = Constructors.getConstructorBindingAnnotated(type2, candidates, candidateAnnotations);
            if (bind2 == null && !hasAutowiredConstructor) {
                bind2 = Constructors.deduceBindConstructor(type2, candidates);
                boolean bl = deducedBindConstructor = bind2 != null;
            }
            if (bind2 == null && !hasAutowiredConstructor && Constructors.isKotlinType(type2)) {
                bind2 = Constructors.deduceKotlinBindConstructor(type2);
                boolean bl = deducedBindConstructor = bind2 != null;
            }
            if (bind2 != null || isNestedConstructorBinding) {
                Assert.state(!hasAutowiredConstructor, () -> type2.getName() + " declares @ConstructorBinding and @Autowired constructor");
            }
            return new Constructors(hasAutowiredConstructor, bind2, deducedBindConstructor, immutableType);
        }

        private static boolean isAutowiredPresent(Class<?> type2) {
            if (Stream.of(type2.getDeclaredConstructors()).map(MergedAnnotations::from).anyMatch(annotations -> annotations.isPresent(Autowired.class))) {
                return true;
            }
            Class<?> userClass = ClassUtils.getUserClass(type2);
            return userClass != type2 && Constructors.isAutowiredPresent(userClass);
        }

        private static Constructor<?>[] getCandidateConstructors(Class<?> type2) {
            if (Constructors.isInnerClass(type2)) {
                return new Constructor[0];
            }
            return (Constructor[])Arrays.stream(type2.getDeclaredConstructors()).filter(Constructors::isNonSynthetic).toArray(Constructor[]::new);
        }

        private static boolean isInnerClass(Class<?> type2) {
            try {
                return type2.getDeclaredField("this$0").isSynthetic();
            }
            catch (NoSuchFieldException ex) {
                return false;
            }
        }

        private static boolean isNonSynthetic(Constructor<?> constructor2) {
            return !constructor2.isSynthetic();
        }

        private static MergedAnnotations[] getAnnotations(Constructor<?>[] candidates) {
            MergedAnnotations[] candidateAnnotations = new MergedAnnotations[candidates.length];
            for (int i2 = 0; i2 < candidates.length; ++i2) {
                candidateAnnotations[i2] = MergedAnnotations.from(candidates[i2], MergedAnnotations.SearchStrategy.SUPERCLASS);
            }
            return candidateAnnotations;
        }

        private static Constructor<?> getConstructorBindingAnnotated(Class<?> type2, Constructor<?>[] candidates, MergedAnnotations[] mergedAnnotations) {
            Constructor<?> result2 = null;
            for (int i2 = 0; i2 < candidates.length; ++i2) {
                if (!mergedAnnotations[i2].isPresent(ConstructorBinding.class)) continue;
                Assert.state(candidates[i2].getParameterCount() > 0, () -> type2.getName() + " declares @ConstructorBinding on a no-args constructor");
                Assert.state(result2 == null, () -> type2.getName() + " has more than one @ConstructorBinding constructor");
                result2 = candidates[i2];
            }
            return result2;
        }

        private static Constructor<?> deduceBindConstructor(Class<?> type2, Constructor<?>[] candidates) {
            if (candidates.length == 1 && candidates[0].getParameterCount() > 0) {
                if (type2.isMemberClass() && Modifier.isPrivate(candidates[0].getModifiers())) {
                    return null;
                }
                return candidates[0];
            }
            Constructor<?> result2 = null;
            for (Constructor<?> candidate : candidates) {
                if (Modifier.isPrivate(candidate.getModifiers())) continue;
                if (result2 != null) {
                    return null;
                }
                result2 = candidate;
            }
            return result2 != null && result2.getParameterCount() > 0 ? result2 : null;
        }

        private static boolean isKotlinType(Class<?> type2) {
            return KotlinDetector.isKotlinPresent() && KotlinDetector.isKotlinType(type2);
        }

        private static Constructor<?> deduceKotlinBindConstructor(Class<?> type2) {
            Constructor<?> primaryConstructor = BeanUtils.findPrimaryConstructor(type2);
            if (primaryConstructor != null && primaryConstructor.getParameterCount() > 0) {
                return primaryConstructor;
            }
            return null;
        }
    }
}

