/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.IndexedElementsBinder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class CollectionBinder
extends IndexedElementsBinder<Collection<Object>> {
    CollectionBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected Object bindAggregate(ConfigurationPropertyName name2, Bindable<?> target2, AggregateElementBinder elementBinder) {
        ResolvableType aggregateType = ResolvableType.forClassWithGenerics(List.class, target2.getType().asCollection().getGenerics());
        ResolvableType elementType = target2.getType().asCollection().getGeneric(new int[0]);
        IndexedElementsBinder.IndexedCollectionSupplier result2 = new IndexedElementsBinder.IndexedCollectionSupplier(() -> CollectionFactory.createCollection(List.class, elementType.resolve(), 0));
        this.bindIndexed(name2, target2, elementBinder, aggregateType, elementType, result2);
        if (result2.wasSupplied()) {
            return result2.get();
        }
        return null;
    }

    @Override
    protected Collection<Object> merge(Supplier<Collection<Object>> existing, Collection<Object> additional) {
        Collection<Object> existingCollection = this.getExistingIfPossible(existing);
        if (existingCollection == null) {
            return additional;
        }
        try {
            existingCollection.clear();
            existingCollection.addAll(additional);
            return this.copyIfPossible(existingCollection);
        }
        catch (UnsupportedOperationException ex) {
            return this.createNewCollection(additional);
        }
    }

    private Collection<Object> getExistingIfPossible(Supplier<Collection<Object>> existing) {
        try {
            return existing.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Collection<Object> copyIfPossible(Collection<Object> collection) {
        try {
            return this.createNewCollection(collection);
        }
        catch (Exception ex) {
            return collection;
        }
    }

    private Collection<Object> createNewCollection(Collection<Object> collection) {
        Collection<Object> result2 = CollectionFactory.createCollection(collection.getClass(), collection.size());
        result2.addAll(collection);
        return result2;
    }
}

