/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.ArrayBinder;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindConverter;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.CollectionBinder;
import org.springframework.boot.context.properties.bind.DataObjectBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyBinder;
import org.springframework.boot.context.properties.bind.JavaBeanBinder;
import org.springframework.boot.context.properties.bind.MapBinder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.ValueObjectBinder;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class Binder {
    private static final Set<Class<?>> NON_BEAN_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Object.class, Class.class)));
    private final Iterable<ConfigurationPropertySource> sources;
    private final PlaceholdersResolver placeholdersResolver;
    private final BindConverter bindConverter;
    private final BindHandler defaultBindHandler;
    private final Map<BindMethod, List<DataObjectBinder>> dataObjectBinders;

    public Binder(ConfigurationPropertySource ... sources) {
        this(sources != null ? Arrays.asList(sources) : null, null, null, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources) {
        this(sources, null, null, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver) {
        this(sources, placeholdersResolver, null, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, ConversionService conversionService) {
        this(sources, placeholdersResolver, conversionService, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, ConversionService conversionService, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        this(sources, placeholdersResolver, conversionService, propertyEditorInitializer, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, ConversionService conversionService, Consumer<PropertyEditorRegistry> propertyEditorInitializer, BindHandler defaultBindHandler) {
        this(sources, placeholdersResolver, conversionService, propertyEditorInitializer, defaultBindHandler, null);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, ConversionService conversionService, Consumer<PropertyEditorRegistry> propertyEditorInitializer, BindHandler defaultBindHandler, BindConstructorProvider constructorProvider) {
        this(sources, placeholdersResolver, conversionService != null ? Collections.singletonList(conversionService) : (List)null, propertyEditorInitializer, defaultBindHandler, constructorProvider);
    }

    public Binder(Iterable<ConfigurationPropertySource> sources, PlaceholdersResolver placeholdersResolver, List<ConversionService> conversionServices, Consumer<PropertyEditorRegistry> propertyEditorInitializer, BindHandler defaultBindHandler, BindConstructorProvider constructorProvider) {
        Assert.notNull(sources, "Sources must not be null");
        for (ConfigurationPropertySource source2 : sources) {
            Assert.notNull((Object)source2, "Sources must not contain null elements");
        }
        this.sources = sources;
        this.placeholdersResolver = placeholdersResolver != null ? placeholdersResolver : PlaceholdersResolver.NONE;
        this.bindConverter = BindConverter.get(conversionServices, propertyEditorInitializer);
        BindHandler bindHandler = this.defaultBindHandler = defaultBindHandler != null ? defaultBindHandler : BindHandler.DEFAULT;
        if (constructorProvider == null) {
            constructorProvider = BindConstructorProvider.DEFAULT;
        }
        ValueObjectBinder valueObjectBinder = new ValueObjectBinder(constructorProvider);
        JavaBeanBinder javaBeanBinder = JavaBeanBinder.INSTANCE;
        HashMap<BindMethod, List<DataObjectBinder>> dataObjectBinders = new HashMap<BindMethod, List<DataObjectBinder>>();
        dataObjectBinders.put(BindMethod.VALUE_OBJECT, List.of(valueObjectBinder));
        dataObjectBinders.put(BindMethod.JAVA_BEAN, List.of(javaBeanBinder));
        dataObjectBinders.put(null, List.of(valueObjectBinder, javaBeanBinder));
        this.dataObjectBinders = Collections.unmodifiableMap(dataObjectBinders);
    }

    public <T> BindResult<T> bind(String name2, Class<T> target2) {
        return this.bind(name2, Bindable.of(target2));
    }

    public <T> BindResult<T> bind(String name2, Bindable<T> target2) {
        return this.bind(ConfigurationPropertyName.of(name2), target2, null);
    }

    public <T> BindResult<T> bind(ConfigurationPropertyName name2, Bindable<T> target2) {
        return this.bind(name2, target2, null);
    }

    public <T> BindResult<T> bind(String name2, Bindable<T> target2, BindHandler handler) {
        return this.bind(ConfigurationPropertyName.of(name2), target2, handler);
    }

    public <T> BindResult<T> bind(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler) {
        T bound = this.bind(name2, target2, handler, false);
        return BindResult.of(bound);
    }

    public <T> T bindOrCreate(String name2, Class<T> target2) {
        return this.bindOrCreate(name2, Bindable.of(target2));
    }

    public <T> T bindOrCreate(String name2, Bindable<T> target2) {
        return this.bindOrCreate(ConfigurationPropertyName.of(name2), target2, null);
    }

    public <T> T bindOrCreate(String name2, Bindable<T> target2, BindHandler handler) {
        return this.bindOrCreate(ConfigurationPropertyName.of(name2), target2, handler);
    }

    public <T> T bindOrCreate(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler) {
        return this.bind(name2, target2, handler, true);
    }

    private <T> T bind(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, boolean create2) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull(target2, "Target must not be null");
        handler = handler != null ? handler : this.defaultBindHandler;
        Context context = new Context();
        return this.bind(name2, target2, handler, context, false, create2);
    }

    private <T> T bind(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, Context context, boolean allowRecursiveBinding, boolean create2) {
        try {
            Bindable<T> replacementTarget = handler.onStart(name2, target2, context);
            if (replacementTarget == null) {
                return this.handleBindResult(name2, target2, handler, context, null, create2);
            }
            target2 = replacementTarget;
            Object bound = this.bindObject(name2, target2, handler, context, allowRecursiveBinding);
            return this.handleBindResult(name2, target2, handler, context, bound, create2);
        }
        catch (Exception ex) {
            return this.handleBindError(name2, target2, handler, context, ex);
        }
    }

    private <T> T handleBindResult(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, Context context, Object result2, boolean create2) throws Exception {
        if (result2 != null) {
            result2 = handler.onSuccess(name2, target2, context, result2);
            result2 = context.getConverter().convert(result2, target2);
        }
        if (result2 == null && create2) {
            result2 = this.fromDataObjectBinders(target2.getBindMethod(), dataObjectBinder -> dataObjectBinder.create(target2, context));
            result2 = handler.onCreate(name2, target2, context, result2);
            result2 = context.getConverter().convert(result2, target2);
            if (result2 == null) {
                IllegalStateException ex = new IllegalStateException("Unable to create instance for " + target2.getType());
                this.dataObjectBinders.get((Object)target2.getBindMethod()).forEach(dataObjectBinder -> dataObjectBinder.onUnableToCreateInstance(target2, context, ex));
                throw ex;
            }
        }
        handler.onFinish(name2, target2, context, result2);
        return context.getConverter().convert(result2, target2);
    }

    private <T> T handleBindError(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, Context context, Exception error2) {
        try {
            Object result2 = handler.onFailure(name2, target2, context, error2);
            return context.getConverter().convert(result2, target2);
        }
        catch (Exception ex) {
            if (ex instanceof BindException) {
                BindException bindException = (BindException)ex;
                throw bindException;
            }
            throw new BindException(name2, target2, context.getConfigurationProperty(), ex);
        }
    }

    private <T> Object bindObject(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, Context context, boolean allowRecursiveBinding) {
        ConfigurationProperty property = this.findProperty(name2, target2, context);
        if (property == null && context.depth != 0 && this.containsNoDescendantOf(context.getSources(), name2)) {
            return null;
        }
        AggregateBinder<?> aggregateBinder = this.getAggregateBinder(target2, context);
        if (aggregateBinder != null) {
            return this.bindAggregate(name2, target2, handler, context, aggregateBinder);
        }
        if (property != null) {
            try {
                return this.bindProperty(target2, context, property);
            }
            catch (ConverterNotFoundException ex) {
                Object instance = this.bindDataObject(name2, target2, handler, context, allowRecursiveBinding);
                if (instance != null) {
                    return instance;
                }
                throw ex;
            }
        }
        return this.bindDataObject(name2, target2, handler, context, allowRecursiveBinding);
    }

    private AggregateBinder<?> getAggregateBinder(Bindable<?> target2, Context context) {
        Class<?> resolvedType = target2.getType().resolve(Object.class);
        if (Map.class.isAssignableFrom(resolvedType)) {
            return new MapBinder(context);
        }
        if (Collection.class.isAssignableFrom(resolvedType)) {
            return new CollectionBinder(context);
        }
        if (target2.getType().isArray()) {
            return new ArrayBinder(context);
        }
        return null;
    }

    private <T> Object bindAggregate(ConfigurationPropertyName name2, Bindable<T> target2, BindHandler handler, Context context, AggregateBinder<?> aggregateBinder) {
        AggregateElementBinder elementBinder = (itemName, itemTarget, source2) -> {
            boolean allowRecursiveBinding = aggregateBinder.isAllowRecursiveBinding(source2);
            Supplier<Object> supplier = () -> this.bind(itemName, itemTarget, handler, context, allowRecursiveBinding, false);
            return context.withSource(source2, supplier);
        };
        return context.withIncreasedDepth(() -> aggregateBinder.bind(name2, target2, elementBinder));
    }

    private <T> ConfigurationProperty findProperty(ConfigurationPropertyName name2, Bindable<T> target2, Context context) {
        if (name2.isEmpty() || target2.hasBindRestriction(Bindable.BindRestriction.NO_DIRECT_PROPERTY)) {
            return null;
        }
        for (ConfigurationPropertySource source2 : context.getSources()) {
            ConfigurationProperty property = source2.getConfigurationProperty(name2);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    private <T> Object bindProperty(Bindable<T> target2, Context context, ConfigurationProperty property) {
        context.setConfigurationProperty(property);
        Object result2 = property.getValue();
        result2 = this.placeholdersResolver.resolvePlaceholders(result2);
        result2 = context.getConverter().convert(result2, target2);
        return result2;
    }

    private Object bindDataObject(ConfigurationPropertyName name2, Bindable<?> target2, BindHandler handler, Context context, boolean allowRecursiveBinding) {
        if (this.isUnbindableBean(name2, target2, context)) {
            return null;
        }
        Class<?> type2 = target2.getType().resolve(Object.class);
        BindMethod bindMethod = target2.getBindMethod();
        if (!allowRecursiveBinding && context.isBindingDataObject(type2)) {
            return null;
        }
        DataObjectPropertyBinder propertyBinder = (propertyName, propertyTarget) -> this.bind(name2.append(propertyName), propertyTarget, handler, context, false, false);
        return context.withDataObject(type2, () -> this.fromDataObjectBinders(bindMethod, dataObjectBinder -> dataObjectBinder.bind(name2, target2, context, propertyBinder)));
    }

    private Object fromDataObjectBinders(BindMethod bindMethod, Function<DataObjectBinder, Object> operation) {
        return this.dataObjectBinders.get((Object)bindMethod).stream().map(operation).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private boolean isUnbindableBean(ConfigurationPropertyName name2, Bindable<?> target2, Context context) {
        for (ConfigurationPropertySource source2 : context.getSources()) {
            if (source2.containsDescendantOf(name2) != ConfigurationPropertyState.PRESENT) continue;
            return false;
        }
        Class<?> resolved = target2.getType().resolve(Object.class);
        if (resolved.isPrimitive() || NON_BEAN_CLASSES.contains(resolved)) {
            return true;
        }
        return resolved.getName().startsWith("java.");
    }

    private boolean containsNoDescendantOf(Iterable<ConfigurationPropertySource> sources, ConfigurationPropertyName name2) {
        for (ConfigurationPropertySource source2 : sources) {
            if (source2.containsDescendantOf(name2) == ConfigurationPropertyState.ABSENT) continue;
            return false;
        }
        return true;
    }

    public static Binder get(Environment environment2) {
        return Binder.get(environment2, null);
    }

    public static Binder get(Environment environment2, BindHandler defaultBindHandler) {
        Iterable<ConfigurationPropertySource> sources = ConfigurationPropertySources.get(environment2);
        PropertySourcesPlaceholdersResolver placeholdersResolver = new PropertySourcesPlaceholdersResolver(environment2);
        return new Binder(sources, placeholdersResolver, null, null, defaultBindHandler);
    }

    final class Context
    implements BindContext {
        private int depth;
        private final List<ConfigurationPropertySource> source = Arrays.asList(new ConfigurationPropertySource[]{null});
        private int sourcePushCount;
        private final Deque<Class<?>> dataObjectBindings = new ArrayDeque();
        private final Deque<Class<?>> constructorBindings = new ArrayDeque();
        private ConfigurationProperty configurationProperty;

        Context() {
        }

        private void increaseDepth() {
            ++this.depth;
        }

        private void decreaseDepth() {
            --this.depth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T withSource(ConfigurationPropertySource source2, Supplier<T> supplier) {
            if (source2 == null) {
                return supplier.get();
            }
            this.source.set(0, source2);
            ++this.sourcePushCount;
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                --this.sourcePushCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T withDataObject(Class<?> type2, Supplier<T> supplier) {
            this.dataObjectBindings.push(type2);
            try {
                T t = this.withIncreasedDepth(supplier);
                return t;
            }
            finally {
                this.dataObjectBindings.pop();
            }
        }

        private boolean isBindingDataObject(Class<?> type2) {
            return this.dataObjectBindings.contains(type2);
        }

        private <T> T withIncreasedDepth(Supplier<T> supplier) {
            this.increaseDepth();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.decreaseDepth();
            }
        }

        void setConfigurationProperty(ConfigurationProperty configurationProperty) {
            this.configurationProperty = configurationProperty;
        }

        void clearConfigurationProperty() {
            this.configurationProperty = null;
        }

        void pushConstructorBoundTypes(Class<?> value2) {
            this.constructorBindings.push(value2);
        }

        boolean isNestedConstructorBinding() {
            return !this.constructorBindings.isEmpty();
        }

        void popConstructorBoundTypes() {
            this.constructorBindings.pop();
        }

        PlaceholdersResolver getPlaceholdersResolver() {
            return Binder.this.placeholdersResolver;
        }

        BindConverter getConverter() {
            return Binder.this.bindConverter;
        }

        @Override
        public Binder getBinder() {
            return Binder.this;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public Iterable<ConfigurationPropertySource> getSources() {
            if (this.sourcePushCount > 0) {
                return this.source;
            }
            return Binder.this.sources;
        }

        @Override
        public ConfigurationProperty getConfigurationProperty() {
            return this.configurationProperty;
        }
    }
}

