/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.JavaBeanBinder;
import org.springframework.boot.context.properties.bind.Nested;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BindableRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    private final Bindable<?>[] bindables;

    protected BindableRuntimeHintsRegistrar(Class<?> ... types) {
        this((Bindable[])Stream.of(types).map(Bindable::of).toArray(Bindable[]::new));
    }

    protected BindableRuntimeHintsRegistrar(Bindable<?> ... bindables) {
        this.bindables = bindables;
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerHints(hints);
    }

    public void registerHints(RuntimeHints hints) {
        for (Bindable<?> bindable : this.bindables) {
            new Processor(bindable).process(hints.reflection());
        }
    }

    public static BindableRuntimeHintsRegistrar forTypes(Iterable<Class<?>> types) {
        Assert.notNull(types, "Types must not be null");
        return BindableRuntimeHintsRegistrar.forTypes((Class[])StreamSupport.stream(types.spliterator(), false).toArray(Class[]::new));
    }

    public static BindableRuntimeHintsRegistrar forTypes(Class<?> ... types) {
        return new BindableRuntimeHintsRegistrar(types);
    }

    public static BindableRuntimeHintsRegistrar forBindables(Iterable<Bindable<?>> bindables) {
        Assert.notNull(bindables, "Bindables must not be null");
        return BindableRuntimeHintsRegistrar.forBindables((Bindable[])StreamSupport.stream(bindables.spliterator(), false).toArray(Bindable[]::new));
    }

    public static BindableRuntimeHintsRegistrar forBindables(Bindable<?> ... bindables) {
        return new BindableRuntimeHintsRegistrar(bindables);
    }

    private static final class Processor {
        private final Class<?> type;
        private final Constructor<?> bindConstructor;
        private final JavaBeanBinder.BeanProperties bean;
        private final Set<Class<?>> seen;

        Processor(Bindable<?> bindable) {
            this(bindable, false, new HashSet());
        }

        private Processor(Bindable<?> bindable, boolean nestedType, Set<Class<?>> seen) {
            this.type = bindable.getType().getRawClass();
            this.bindConstructor = bindable.getBindMethod() != BindMethod.JAVA_BEAN ? BindConstructorProvider.DEFAULT.getBindConstructor(bindable.getType().resolve(), nestedType) : null;
            this.bean = JavaBeanBinder.BeanProperties.of(bindable);
            this.seen = seen;
        }

        void process(ReflectionHints hints) {
            if (this.seen.contains(this.type)) {
                return;
            }
            this.seen.add(this.type);
            this.handleConstructor(hints);
            if (this.bindConstructor != null) {
                this.handleValueObjectProperties(hints);
            } else if (this.bean != null && !this.bean.getProperties().isEmpty()) {
                this.handleJavaBeanProperties(hints);
            }
        }

        private void handleConstructor(ReflectionHints hints) {
            if (this.bindConstructor != null) {
                if (KotlinDetector.isKotlinType(this.bindConstructor.getDeclaringClass())) {
                    KotlinDelegate.handleConstructor(hints, this.bindConstructor);
                } else {
                    hints.registerConstructor(this.bindConstructor, ExecutableMode.INVOKE);
                }
                return;
            }
            Arrays.stream(this.type.getDeclaredConstructors()).filter(this::hasNoParameters).findFirst().ifPresent(constructor2 -> hints.registerConstructor((Constructor<?>)constructor2, ExecutableMode.INVOKE));
        }

        private boolean hasNoParameters(Constructor<?> candidate) {
            return candidate.getParameterCount() == 0;
        }

        private void handleValueObjectProperties(ReflectionHints hints) {
            for (int i2 = 0; i2 < this.bindConstructor.getParameterCount(); ++i2) {
                String propertyName = this.bindConstructor.getParameters()[i2].getName();
                ResolvableType propertyType = ResolvableType.forConstructorParameter(this.bindConstructor, i2);
                this.handleProperty(hints, propertyName, propertyType);
            }
        }

        private void handleJavaBeanProperties(ReflectionHints hints) {
            Map<String, JavaBeanBinder.BeanProperty> properties = this.bean.getProperties();
            properties.forEach((name2, property) -> {
                Method setter;
                Method getter = property.getGetter();
                if (getter != null) {
                    hints.registerMethod(getter, ExecutableMode.INVOKE);
                }
                if ((setter = property.getSetter()) != null) {
                    hints.registerMethod(setter, ExecutableMode.INVOKE);
                }
                this.handleProperty(hints, (String)name2, property.getType());
            });
        }

        private void handleProperty(ReflectionHints hints, String propertyName, ResolvableType propertyType) {
            Class<?> propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return;
            }
            if (propertyClass.equals(this.type)) {
                return;
            }
            Class<?> componentType = this.getComponentClass(propertyType);
            if (componentType != null) {
                if (!this.isJavaType(componentType)) {
                    this.processNested(componentType, hints);
                }
            } else if (this.isNestedType(propertyName, propertyClass)) {
                this.processNested(propertyClass, hints);
            }
        }

        private void processNested(Class<?> type2, ReflectionHints hints) {
            new Processor(Bindable.of(type2), true, this.seen).process(hints);
        }

        private Class<?> getComponentClass(ResolvableType type2) {
            ResolvableType componentType = this.getComponentType(type2);
            if (componentType == null) {
                return null;
            }
            if (this.isContainer(componentType)) {
                return this.getComponentClass(componentType);
            }
            return componentType.toClass();
        }

        private ResolvableType getComponentType(ResolvableType type2) {
            if (type2.isArray()) {
                return type2.getComponentType();
            }
            if (this.isCollection(type2)) {
                return type2.asCollection().getGeneric(new int[0]);
            }
            if (this.isMap(type2)) {
                return type2.asMap().getGeneric(1);
            }
            return null;
        }

        private boolean isContainer(ResolvableType type2) {
            return type2.isArray() || this.isCollection(type2) || this.isMap(type2);
        }

        private boolean isCollection(ResolvableType type2) {
            return Collection.class.isAssignableFrom(type2.toClass());
        }

        private boolean isMap(ResolvableType type2) {
            return Map.class.isAssignableFrom(type2.toClass());
        }

        private boolean isNestedType(String propertyName, Class<?> propertyType) {
            Class<?> declaringClass = propertyType.getDeclaringClass();
            if (declaringClass != null && Processor.isNested(declaringClass, this.type)) {
                return true;
            }
            Field field = ReflectionUtils.findField(this.type, propertyName);
            return field != null && MergedAnnotations.from(field).isPresent(Nested.class);
        }

        private static boolean isNested(Class<?> type2, Class<?> candidate) {
            if (type2.isAssignableFrom(candidate)) {
                return true;
            }
            return candidate.getDeclaringClass() != null && Processor.isNested(type2, candidate.getDeclaringClass());
        }

        private boolean isJavaType(Class<?> candidate) {
            return candidate.getPackageName().startsWith("java.");
        }
    }

    private static final class KotlinDelegate {
        private KotlinDelegate() {
        }

        static void handleConstructor(ReflectionHints hints, Constructor<?> constructor2) {
            KClass kClass = JvmClassMappingKt.getKotlinClass(constructor2.getDeclaringClass());
            if (kClass.isData()) {
                hints.registerType(constructor2.getDeclaringClass(), MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
            } else {
                hints.registerConstructor(constructor2, ExecutableMode.INVOKE);
            }
        }
    }
}

