/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Bindable<T> {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final EnumSet<BindRestriction> NO_BIND_RESTRICTIONS = EnumSet.noneOf(BindRestriction.class);
    private final ResolvableType type;
    private final ResolvableType boxedType;
    private final Supplier<T> value;
    private final Annotation[] annotations;
    private final EnumSet<BindRestriction> bindRestrictions;
    private final BindMethod bindMethod;

    private Bindable(ResolvableType type2, ResolvableType boxedType, Supplier<T> value2, Annotation[] annotations, EnumSet<BindRestriction> bindRestrictions, BindMethod bindMethod) {
        this.type = type2;
        this.boxedType = boxedType;
        this.value = value2;
        this.annotations = annotations;
        this.bindRestrictions = bindRestrictions;
        this.bindMethod = bindMethod;
    }

    public ResolvableType getType() {
        return this.type;
    }

    public ResolvableType getBoxedType() {
        return this.boxedType;
    }

    public Supplier<T> getValue() {
        return this.value;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type2) {
        for (Annotation annotation : this.annotations) {
            if (!type2.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    public boolean hasBindRestriction(BindRestriction bindRestriction) {
        return this.bindRestrictions.contains((Object)bindRestriction);
    }

    public BindMethod getBindMethod() {
        return this.bindMethod;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bindable other = (Bindable)obj;
        boolean result2 = true;
        result2 = result2 && this.nullSafeEquals(this.type.resolve(), other.type.resolve());
        result2 = result2 && this.nullSafeEquals(this.annotations, other.annotations);
        result2 = result2 && this.nullSafeEquals(this.bindRestrictions, other.bindRestrictions);
        result2 = result2 && this.nullSafeEquals((Object)this.bindMethod, (Object)other.bindMethod);
        return result2;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(new Object[]{this.type, this.annotations, this.bindRestrictions, this.bindMethod});
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("type", this.type);
        creator.append("value", this.value != null ? "provided" : "none");
        creator.append("annotations", this.annotations);
        creator.append("bindMethod", (Object)this.bindMethod);
        return creator.toString();
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        return ObjectUtils.nullSafeEquals(o1, o2);
    }

    public Bindable<T> withAnnotations(Annotation ... annotations) {
        return new Bindable<T>(this.type, this.boxedType, this.value, annotations != null ? annotations : NO_ANNOTATIONS, NO_BIND_RESTRICTIONS, this.bindMethod);
    }

    public Bindable<T> withExistingValue(T existingValue) {
        Assert.isTrue(existingValue == null || this.type.isArray() || this.boxedType.resolve().isInstance(existingValue), () -> "ExistingValue must be an instance of " + this.type);
        Assert.state(this.bindMethod != BindMethod.VALUE_OBJECT, () -> "An existing value cannot be provided when binding as a value object");
        Supplier<Object> value2 = existingValue != null ? () -> existingValue : null;
        return new Bindable<Object>(this.type, this.boxedType, value2, this.annotations, this.bindRestrictions, BindMethod.JAVA_BEAN);
    }

    public Bindable<T> withSuppliedValue(Supplier<T> suppliedValue) {
        return new Bindable<T>(this.type, this.boxedType, suppliedValue, this.annotations, this.bindRestrictions, this.bindMethod);
    }

    public Bindable<T> withBindRestrictions(BindRestriction ... additionalRestrictions) {
        EnumSet<BindRestriction> bindRestrictions = EnumSet.copyOf(this.bindRestrictions);
        bindRestrictions.addAll(Arrays.asList(additionalRestrictions));
        return new Bindable<T>(this.type, this.boxedType, this.value, this.annotations, bindRestrictions, this.bindMethod);
    }

    public Bindable<T> withBindMethod(BindMethod bindMethod) {
        Assert.state(bindMethod != BindMethod.VALUE_OBJECT || this.value == null, () -> "Value object binding cannot be used with an existing or supplied value");
        return new Bindable<T>(this.type, this.boxedType, this.value, this.annotations, this.bindRestrictions, bindMethod);
    }

    public static <T> Bindable<T> ofInstance(T instance) {
        Assert.notNull(instance, "Instance must not be null");
        Class<?> type2 = instance.getClass();
        return Bindable.of(type2).withExistingValue(instance);
    }

    public static <T> Bindable<T> of(Class<T> type2) {
        Assert.notNull(type2, "Type must not be null");
        return Bindable.of(ResolvableType.forClass(type2));
    }

    public static <E> Bindable<List<E>> listOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(List.class, elementType));
    }

    public static <E> Bindable<Set<E>> setOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(Set.class, elementType));
    }

    public static <K, V> Bindable<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(Map.class, keyType, valueType));
    }

    public static <T> Bindable<T> of(ResolvableType type2) {
        Assert.notNull((Object)type2, "Type must not be null");
        ResolvableType boxedType = Bindable.box(type2);
        return new Bindable<T>(type2, boxedType, null, NO_ANNOTATIONS, NO_BIND_RESTRICTIONS, null);
    }

    private static ResolvableType box(ResolvableType type2) {
        Class<?> resolved = type2.resolve();
        if (resolved != null && resolved.isPrimitive()) {
            Object array2 = Array.newInstance(resolved, 1);
            Class<?> wrapperType = Array.get(array2, 0).getClass();
            return ResolvableType.forClass(wrapperType);
        }
        if (resolved != null && resolved.isArray()) {
            return ResolvableType.forArrayComponent(Bindable.box(type2.getComponentType()));
        }
        return type2;
    }

    public static enum BindRestriction {
        NO_DIRECT_PROPERTY;

    }
}

