/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;

public class BindException
extends RuntimeException
implements OriginProvider {
    private final Bindable<?> target;
    private final ConfigurationProperty property;
    private final ConfigurationPropertyName name;

    BindException(ConfigurationPropertyName name2, Bindable<?> target2, ConfigurationProperty property, Throwable cause2) {
        super(BindException.buildMessage(name2, target2), cause2);
        this.name = name2;
        this.target = target2;
        this.property = property;
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Bindable<?> getTarget() {
        return this.target;
    }

    public ConfigurationProperty getProperty() {
        return this.property;
    }

    @Override
    public Origin getOrigin() {
        return Origin.from(this.name);
    }

    private static String buildMessage(ConfigurationPropertyName name2, Bindable<?> target2) {
        StringBuilder message2 = new StringBuilder();
        message2.append("Failed to bind properties");
        message2.append((String)(name2 != null ? " under '" + name2 + "'" : ""));
        message2.append(" to ").append(target2.getType());
        return message2.toString();
    }
}

