/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

final class BindConverter {
    private static BindConverter sharedInstance;
    private final List<ConversionService> delegates;

    private BindConverter(List<ConversionService> conversionServices, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        ArrayList<ConversionService> delegates = new ArrayList<ConversionService>();
        delegates.add(new TypeConverterConversionService(propertyEditorInitializer));
        boolean hasApplication = false;
        if (!CollectionUtils.isEmpty(conversionServices)) {
            for (ConversionService conversionService : conversionServices) {
                delegates.add(conversionService);
                hasApplication = hasApplication || conversionService instanceof ApplicationConversionService;
            }
        }
        if (!hasApplication) {
            delegates.add(ApplicationConversionService.getSharedInstance());
        }
        this.delegates = Collections.unmodifiableList(delegates);
    }

    boolean canConvert(Object source2, ResolvableType targetType, Annotation ... targetAnnotations) {
        return this.canConvert(TypeDescriptor.forObject(source2), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    private boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (ConversionService service : this.delegates) {
            if (!service.canConvert(sourceType, targetType)) continue;
            return true;
        }
        return false;
    }

    <T> T convert(Object source2, Bindable<T> target2) {
        return this.convert(source2, target2.getType(), target2.getAnnotations());
    }

    <T> T convert(Object source2, ResolvableType targetType, Annotation ... targetAnnotations) {
        if (source2 == null) {
            return null;
        }
        return (T)this.convert(source2, TypeDescriptor.forObject(source2), new ResolvableTypeDescriptor(targetType, targetAnnotations));
    }

    private Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        ConversionException failure = null;
        for (ConversionService delegate : this.delegates) {
            try {
                if (!delegate.canConvert(sourceType, targetType)) continue;
                return delegate.convert(source2, sourceType, targetType);
            }
            catch (ConversionException ex) {
                if (failure != null || !(ex instanceof ConversionFailedException)) continue;
                failure = ex;
            }
        }
        throw failure != null ? failure : new ConverterNotFoundException(sourceType, targetType);
    }

    static BindConverter get(List<ConversionService> conversionServices, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        boolean sharedApplicationConversionService;
        boolean bl = sharedApplicationConversionService = conversionServices == null || conversionServices.size() == 1 && conversionServices.get(0) == ApplicationConversionService.getSharedInstance();
        if (propertyEditorInitializer == null && sharedApplicationConversionService) {
            return BindConverter.getSharedInstance();
        }
        return new BindConverter(conversionServices, propertyEditorInitializer);
    }

    private static BindConverter getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BindConverter(null, null);
        }
        return sharedInstance;
    }

    private static class TypeConverterConversionService
    extends GenericConversionService {
        TypeConverterConversionService(Consumer<PropertyEditorRegistry> initializer) {
            ApplicationConversionService.addDelimitedStringConverters(this);
            this.addConverter(new TypeConverterConverter(initializer));
        }

        @Override
        public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (targetType.isArray() && targetType.getElementTypeDescriptor().isPrimitive()) {
                return false;
            }
            return super.canConvert(sourceType, targetType);
        }
    }

    private static class ResolvableTypeDescriptor
    extends TypeDescriptor {
        ResolvableTypeDescriptor(ResolvableType resolvableType, Annotation[] annotations) {
            super(resolvableType, null, annotations);
        }
    }

    private static class TypeConverterConverter
    implements ConditionalGenericConverter {
        private static final Set<Class<?>> EXCLUDED_EDITORS;
        private final Consumer<PropertyEditorRegistry> initializer;
        private final SimpleTypeConverter matchesOnlyTypeConverter;

        TypeConverterConverter(Consumer<PropertyEditorRegistry> initializer) {
            this.initializer = initializer;
            this.matchesOnlyTypeConverter = this.createTypeConverter();
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Set.of(new GenericConverter.ConvertiblePair(String.class, Object.class), new GenericConverter.ConvertiblePair(String.class, Resource[].class), new GenericConverter.ConvertiblePair(String.class, Collection.class));
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            TypeDescriptor elementType;
            Class<?> type2 = targetType.getType();
            if (type2 == null || type2 == Object.class || Map.class.isAssignableFrom(type2)) {
                return false;
            }
            if (Collection.class.isAssignableFrom(type2) && ((elementType = targetType.getElementTypeDescriptor()) == null || !Resource.class.isAssignableFrom(elementType.getType()))) {
                return false;
            }
            PropertyEditor editor = this.matchesOnlyTypeConverter.getDefaultEditor(type2);
            if (editor == null) {
                editor = this.matchesOnlyTypeConverter.findCustomEditor(type2, null);
            }
            if (editor == null && String.class != type2) {
                editor = BeanUtils.findEditorByConvention(type2);
            }
            return editor != null && !EXCLUDED_EDITORS.contains(editor.getClass());
        }

        @Override
        public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.createTypeConverter().convertIfNecessary(source2, targetType.getType(), targetType);
        }

        private SimpleTypeConverter createTypeConverter() {
            SimpleTypeConverter typeConverter = new SimpleTypeConverter();
            if (this.initializer != null) {
                this.initializer.accept(typeConverter);
            }
            return typeConverter;
        }

        static {
            HashSet<Class<FileEditor>> excluded = new HashSet<Class<FileEditor>>();
            excluded.add(CustomNumberEditor.class);
            excluded.add(CustomBooleanEditor.class);
            excluded.add(FileEditor.class);
            EXCLUDED_EDITORS = Collections.unmodifiableSet(excluded);
        }
    }
}

