/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.BindMethodAttribute;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConstructorBound;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ConfigurationPropertiesBeanRegistrar {
    private final BeanDefinitionRegistry registry;
    private final BeanFactory beanFactory;

    ConfigurationPropertiesBeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
        this.beanFactory = (BeanFactory)((Object)this.registry);
    }

    void register(Class<?> type2) {
        MergedAnnotation<ConfigurationProperties> annotation = MergedAnnotations.from(type2, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ConfigurationProperties.class);
        this.register(type2, annotation);
    }

    void register(Class<?> type2, MergedAnnotation<ConfigurationProperties> annotation) {
        String name2 = this.getName(type2, annotation);
        if (!this.containsBeanDefinition(name2)) {
            this.registerBeanDefinition(name2, type2, annotation);
        }
    }

    private String getName(Class<?> type2, MergedAnnotation<ConfigurationProperties> annotation) {
        String prefix = annotation.isPresent() ? annotation.getString("prefix") : "";
        return StringUtils.hasText(prefix) ? prefix + "-" + type2.getName() : type2.getName();
    }

    private boolean containsBeanDefinition(String name2) {
        return this.containsBeanDefinition(this.beanFactory, name2);
    }

    private boolean containsBeanDefinition(BeanFactory beanFactory, String name2) {
        ListableBeanFactory listableBeanFactory;
        if (beanFactory instanceof ListableBeanFactory && (listableBeanFactory = (ListableBeanFactory)beanFactory).containsBeanDefinition(name2)) {
            return true;
        }
        if (beanFactory instanceof HierarchicalBeanFactory) {
            HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory;
            return this.containsBeanDefinition(hierarchicalBeanFactory.getParentBeanFactory(), name2);
        }
        return false;
    }

    private void registerBeanDefinition(String beanName, Class<?> type2, MergedAnnotation<ConfigurationProperties> annotation) {
        Assert.state(annotation.isPresent(), () -> "No " + ConfigurationProperties.class.getSimpleName() + " annotation found on  '" + type2.getName() + "'.");
        this.registry.registerBeanDefinition(beanName, this.createBeanDefinition(beanName, type2));
    }

    private BeanDefinition createBeanDefinition(String beanName, Class<?> type2) {
        BindMethod bindMethod = ConfigurationPropertiesBean.deduceBindMethod(type2);
        RootBeanDefinition definition = new RootBeanDefinition(type2);
        BindMethodAttribute.set(definition, bindMethod);
        if (bindMethod == BindMethod.VALUE_OBJECT) {
            definition.setInstanceSupplier(() -> ConstructorBound.from(this.beanFactory, beanName, type2));
        }
        return definition;
    }
}

