/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.metrics.buffering;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.springframework.boot.context.metrics.buffering.BufferedStartupStep;
import org.springframework.boot.context.metrics.buffering.StartupTimeline;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.util.Assert;

public class BufferingApplicationStartup
implements ApplicationStartup {
    private final int capacity;
    private final Clock clock;
    private Instant startTime;
    private final AtomicInteger idSeq = new AtomicInteger();
    private Predicate<StartupStep> filter = step2 -> true;
    private final AtomicReference<BufferedStartupStep> current = new AtomicReference();
    private final AtomicInteger estimatedSize = new AtomicInteger();
    private final ConcurrentLinkedQueue<StartupTimeline.TimelineEvent> events = new ConcurrentLinkedQueue();

    public BufferingApplicationStartup(int capacity) {
        this(capacity, Clock.systemDefaultZone());
    }

    BufferingApplicationStartup(int capacity, Clock clock) {
        this.capacity = capacity;
        this.clock = clock;
        this.startTime = clock.instant();
    }

    public void startRecording() {
        Assert.state(this.events.isEmpty(), "Cannot restart recording once steps have been buffered.");
        this.startTime = this.clock.instant();
    }

    public void addFilter(Predicate<StartupStep> filter2) {
        this.filter = this.filter.and(filter2);
    }

    @Override
    public StartupStep start(String name2) {
        BufferedStartupStep parent;
        BufferedStartupStep next2;
        BufferedStartupStep current2;
        int id2 = this.idSeq.getAndIncrement();
        Instant start2 = this.clock.instant();
        while (!this.current.compareAndSet(current2 = this.current.get(), next2 = new BufferedStartupStep(parent = this.getLatestActive(current2), name2, id2, start2, this::record))) {
        }
        return next2;
    }

    private void record(BufferedStartupStep step2) {
        BufferedStartupStep next2;
        BufferedStartupStep current2;
        if (this.filter.test(step2) && this.estimatedSize.get() < this.capacity) {
            this.estimatedSize.incrementAndGet();
            this.events.add(new StartupTimeline.TimelineEvent(step2, this.clock.instant()));
        }
        while (!this.current.compareAndSet(current2 = this.current.get(), next2 = this.getLatestActive(current2))) {
        }
    }

    private BufferedStartupStep getLatestActive(BufferedStartupStep step2) {
        while (step2 != null && step2.isEnded()) {
            step2 = step2.getParent();
        }
        return step2;
    }

    public StartupTimeline getBufferedTimeline() {
        return new StartupTimeline(this.startTime, new ArrayList<StartupTimeline.TimelineEvent>(this.events));
    }

    public StartupTimeline drainBufferedTimeline() {
        ArrayList<StartupTimeline.TimelineEvent> events = new ArrayList<StartupTimeline.TimelineEvent>();
        Iterator<StartupTimeline.TimelineEvent> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            events.add(iterator.next());
            iterator.remove();
        }
        this.estimatedSize.set(0);
        return new StartupTimeline(this.startTime, events);
    }
}

