/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.metrics.buffering;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.metrics.StartupStep;
import org.springframework.util.Assert;

class BufferedStartupStep
implements StartupStep {
    private final String name;
    private final long id;
    private final BufferedStartupStep parent;
    private final List<StartupStep.Tag> tags = new ArrayList<StartupStep.Tag>();
    private final Consumer<BufferedStartupStep> recorder;
    private final Instant startTime;
    private final AtomicBoolean ended = new AtomicBoolean();

    BufferedStartupStep(BufferedStartupStep parent, String name2, long id2, Instant startTime, Consumer<BufferedStartupStep> recorder) {
        this.parent = parent;
        this.name = name2;
        this.id = id2;
        this.startTime = startTime;
        this.recorder = recorder;
    }

    BufferedStartupStep getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Long getParentId() {
        return this.parent != null ? Long.valueOf(this.parent.getId()) : null;
    }

    @Override
    public StartupStep.Tags getTags() {
        return Collections.unmodifiableList(this.tags)::iterator;
    }

    @Override
    public StartupStep tag(String key2, Supplier<String> value2) {
        return this.tag(key2, value2.get());
    }

    @Override
    public StartupStep tag(String key2, String value2) {
        Assert.state(!this.ended.get(), "StartupStep has already ended.");
        this.tags.add(new DefaultTag(key2, value2));
        return this;
    }

    @Override
    public void end() {
        this.ended.set(true);
        this.recorder.accept(this);
    }

    boolean isEnded() {
        return this.ended.get();
    }

    static class DefaultTag
    implements StartupStep.Tag {
        private final String key;
        private final String value;

        DefaultTag(String key2, String value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

