/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class Profiles
implements Iterable<String> {
    public static final String INCLUDE_PROFILES_PROPERTY_NAME = "spring.profiles.include";
    static final ConfigurationPropertyName INCLUDE_PROFILES = ConfigurationPropertyName.of("spring.profiles.include");
    private static final Bindable<MultiValueMap<String, String>> STRING_STRINGS_MAP = Bindable.of(ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, String.class));
    private static final Bindable<Set<String>> STRING_SET = Bindable.setOf(String.class);
    private final MultiValueMap<String, String> groups;
    private final List<String> activeProfiles;
    private final List<String> defaultProfiles;

    Profiles(Environment environment2, Binder binder, Collection<String> additionalProfiles) {
        this.groups = binder.bind("spring.profiles.group", STRING_STRINGS_MAP).orElseGet(LinkedMultiValueMap::new);
        this.activeProfiles = this.expandProfiles(this.getActivatedProfiles(environment2, binder, additionalProfiles));
        this.defaultProfiles = this.expandProfiles(this.getDefaultProfiles(environment2, binder));
    }

    private List<String> getActivatedProfiles(Environment environment2, Binder binder, Collection<String> additionalProfiles) {
        return this.asUniqueItemList(this.getProfiles(environment2, binder, Type.ACTIVE), additionalProfiles);
    }

    private List<String> getDefaultProfiles(Environment environment2, Binder binder) {
        return this.asUniqueItemList(this.getProfiles(environment2, binder, Type.DEFAULT));
    }

    private Collection<String> getProfiles(Environment environment2, Binder binder, Type type2) {
        String environmentPropertyValue = environment2.getProperty(type2.getName());
        Set<String> environmentPropertyProfiles = !StringUtils.hasLength(environmentPropertyValue) ? Collections.emptySet() : StringUtils.commaDelimitedListToSet(StringUtils.trimAllWhitespace(environmentPropertyValue));
        LinkedHashSet<String> environmentProfiles = new LinkedHashSet<String>(Arrays.asList(type2.get(environment2)));
        BindResult<Set<String>> boundProfiles = binder.bind(type2.getName(), STRING_SET);
        if (this.hasProgrammaticallySetProfiles(type2, environmentPropertyValue, environmentPropertyProfiles, environmentProfiles)) {
            if (!type2.isMergeWithEnvironmentProfiles() || !boundProfiles.isBound()) {
                return environmentProfiles;
            }
            return boundProfiles.map(bound -> this.merge((Set<String>)environmentProfiles, (Set<String>)bound)).get();
        }
        return boundProfiles.orElse(type2.getDefaultValue());
    }

    private boolean hasProgrammaticallySetProfiles(Type type2, String environmentPropertyValue, Set<String> environmentPropertyProfiles, Set<String> environmentProfiles) {
        if (!StringUtils.hasLength(environmentPropertyValue)) {
            return !type2.getDefaultValue().equals(environmentProfiles);
        }
        if (type2.getDefaultValue().equals(environmentProfiles)) {
            return false;
        }
        return !environmentPropertyProfiles.equals(environmentProfiles);
    }

    private Set<String> merge(Set<String> environmentProfiles, Set<String> bound) {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>(environmentProfiles);
        result2.addAll(bound);
        return result2;
    }

    private List<String> expandProfiles(List<String> profiles) {
        ArrayDeque stack = new ArrayDeque();
        this.asReversedList(profiles).forEach(stack::push);
        LinkedHashSet<String> expandedProfiles = new LinkedHashSet<String>();
        while (!stack.isEmpty()) {
            String current2 = (String)stack.pop();
            if (!expandedProfiles.add(current2)) continue;
            this.asReversedList((List)this.groups.get(current2)).forEach(stack::push);
        }
        return this.asUniqueItemList(expandedProfiles);
    }

    private List<String> asReversedList(List<String> list2) {
        if (CollectionUtils.isEmpty(list2)) {
            return Collections.emptyList();
        }
        ArrayList<String> reversed = new ArrayList<String>(list2);
        Collections.reverse(reversed);
        return reversed;
    }

    private List<String> asUniqueItemList(Collection<String> profiles) {
        return this.asUniqueItemList(profiles, null);
    }

    private List<String> asUniqueItemList(Collection<String> profiles, Collection<String> additional) {
        LinkedHashSet<String> uniqueItems = new LinkedHashSet<String>();
        if (!CollectionUtils.isEmpty(additional)) {
            uniqueItems.addAll(additional);
        }
        uniqueItems.addAll(profiles);
        return Collections.unmodifiableList(new ArrayList(uniqueItems));
    }

    @Override
    public Iterator<String> iterator() {
        return this.getAccepted().iterator();
    }

    public List<String> getActive() {
        return this.activeProfiles;
    }

    public List<String> getDefault() {
        return this.defaultProfiles;
    }

    public List<String> getAccepted() {
        return !this.activeProfiles.isEmpty() ? this.activeProfiles : this.defaultProfiles;
    }

    public boolean isAccepted(String profile2) {
        return this.getAccepted().contains(profile2);
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("active", this.getActive().toString());
        creator.append("default", this.getDefault().toString());
        creator.append("accepted", this.getAccepted().toString());
        return creator.toString();
    }

    private static enum Type {
        ACTIVE("spring.profiles.active", Environment::getActiveProfiles, true, Collections.emptySet()),
        DEFAULT("spring.profiles.default", Environment::getDefaultProfiles, false, Collections.singleton("default"));

        private final Function<Environment, String[]> getter;
        private final boolean mergeWithEnvironmentProfiles;
        private final String name;
        private final Set<String> defaultValue;

        private Type(String name2, Function<Environment, String[]> getter, boolean mergeWithEnvironmentProfiles, Set<String> defaultValue) {
            this.name = name2;
            this.getter = getter;
            this.mergeWithEnvironmentProfiles = mergeWithEnvironmentProfiles;
            this.defaultValue = defaultValue;
        }

        String getName() {
            return this.name;
        }

        String[] get(Environment environment2) {
            return this.getter.apply(environment2);
        }

        Set<String> getDefaultValue() {
            return this.defaultValue;
        }

        boolean isMergeWithEnvironmentProfiles() {
            return this.mergeWithEnvironmentProfiles;
        }
    }
}

