/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.springframework.boot.context.config.ConfigDataEnvironmentContributor;
import org.springframework.boot.context.config.ConfigDataException;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.core.env.PropertySource;

public class InactiveConfigDataAccessException
extends ConfigDataException {
    private final PropertySource<?> propertySource;
    private final ConfigDataResource location;
    private final String propertyName;
    private final Origin origin;

    InactiveConfigDataAccessException(PropertySource<?> propertySource, ConfigDataResource location, String propertyName, Origin origin) {
        super(InactiveConfigDataAccessException.getMessage(propertySource, location, propertyName, origin), null);
        this.propertySource = propertySource;
        this.location = location;
        this.propertyName = propertyName;
        this.origin = origin;
    }

    private static String getMessage(PropertySource<?> propertySource, ConfigDataResource location, String propertyName, Origin origin) {
        StringBuilder message2 = new StringBuilder("Inactive property source '");
        message2.append(propertySource.getName());
        if (location != null) {
            message2.append("' imported from location '");
            message2.append(location);
        }
        message2.append("' cannot contain property '");
        message2.append(propertyName);
        message2.append("'");
        if (origin != null) {
            message2.append(" [origin: ");
            message2.append(origin);
            message2.append("]");
        }
        return message2.toString();
    }

    public PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public ConfigDataResource getLocation() {
        return this.location;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    static void throwIfPropertyFound(ConfigDataEnvironmentContributor contributor, ConfigurationPropertyName name2) {
        ConfigurationProperty property;
        ConfigurationPropertySource source2 = contributor.getConfigurationPropertySource();
        ConfigurationProperty configurationProperty = property = source2 != null ? source2.getConfigurationProperty(name2) : null;
        if (property != null) {
            PropertySource<?> propertySource = contributor.getPropertySource();
            ConfigDataResource location = contributor.getResource();
            throw new InactiveConfigDataAccessException(propertySource, location, name2.toString(), property.getOrigin());
        }
    }
}

