/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;

class ConfigDataLocationBindHandler
extends AbstractBindHandler {
    ConfigDataLocationBindHandler() {
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name2, Bindable<?> target2, BindContext context, Object result2) {
        if (result2 instanceof ConfigDataLocation) {
            ConfigDataLocation location = (ConfigDataLocation)result2;
            return this.withOrigin(context, location);
        }
        if (result2 instanceof List) {
            List list2 = (List)result2;
            return list2.stream().filter(Objects::nonNull).map(element -> {
                Object object;
                if (element instanceof ConfigDataLocation) {
                    ConfigDataLocation location = (ConfigDataLocation)element;
                    object = this.withOrigin(context, location);
                } else {
                    object = element;
                }
                return object;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        if (result2 instanceof ConfigDataLocation[]) {
            ConfigDataLocation[] unfilteredLocations = (ConfigDataLocation[])result2;
            return Arrays.stream(unfilteredLocations).filter(Objects::nonNull).map(element -> this.withOrigin(context, (ConfigDataLocation)element)).toArray(ConfigDataLocation[]::new);
        }
        return result2;
    }

    private ConfigDataLocation withOrigin(BindContext context, ConfigDataLocation result2) {
        if (result2.getOrigin() != null) {
            return result2;
        }
        Origin origin = Origin.from(context.getConfigurationProperty());
        return result2.withOrigin(origin);
    }
}

