/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.ConfigDataEnvironmentContributor;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.InactiveConfigDataAccessException;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.PropertySource;
import org.springframework.util.PropertyPlaceholderHelper;

class ConfigDataEnvironmentContributorPlaceholdersResolver
implements PlaceholdersResolver {
    private final Iterable<ConfigDataEnvironmentContributor> contributors;
    private final ConfigDataActivationContext activationContext;
    private final boolean failOnResolveFromInactiveContributor;
    private final PropertyPlaceholderHelper helper;
    private final ConfigDataEnvironmentContributor activeContributor;
    private final ConversionService conversionService;

    ConfigDataEnvironmentContributorPlaceholdersResolver(Iterable<ConfigDataEnvironmentContributor> contributors, ConfigDataActivationContext activationContext, ConfigDataEnvironmentContributor activeContributor, boolean failOnResolveFromInactiveContributor, ConversionService conversionService) {
        this.contributors = contributors;
        this.activationContext = activationContext;
        this.activeContributor = activeContributor;
        this.failOnResolveFromInactiveContributor = failOnResolveFromInactiveContributor;
        this.conversionService = conversionService;
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", true);
    }

    @Override
    public Object resolvePlaceholders(Object value2) {
        if (value2 instanceof String) {
            String string2 = (String)value2;
            return this.helper.replacePlaceholders(string2, this::resolvePlaceholder);
        }
        return value2;
    }

    private String resolvePlaceholder(String placeholder) {
        Object result2 = null;
        for (ConfigDataEnvironmentContributor contributor : this.contributors) {
            Object value2;
            PropertySource<?> propertySource = contributor.getPropertySource();
            Object object = value2 = propertySource != null ? propertySource.getProperty(placeholder) : null;
            if (value2 != null && !this.isActive(contributor)) {
                if (this.failOnResolveFromInactiveContributor) {
                    ConfigDataResource resource = contributor.getResource();
                    Origin origin = OriginLookup.getOrigin(propertySource, placeholder);
                    throw new InactiveConfigDataAccessException(propertySource, resource, placeholder, origin);
                }
                value2 = null;
            }
            result2 = result2 != null ? result2 : value2;
        }
        return result2 != null ? this.convertValueIfNecessary(result2) : null;
    }

    private boolean isActive(ConfigDataEnvironmentContributor contributor) {
        if (contributor == this.activeContributor) {
            return true;
        }
        if (contributor.getKind() != ConfigDataEnvironmentContributor.Kind.UNBOUND_IMPORT) {
            return contributor.isActive(this.activationContext);
        }
        return contributor.withBoundProperties(this.contributors, this.activationContext).isActive(this.activationContext);
    }

    private String convertValueIfNecessary(Object value2) {
        String string2;
        return value2 instanceof String ? (string2 = (String)value2) : this.conversionService.convert(value2, String.class);
    }
}

