/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ConfigurationWarningsApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Log logger = LogFactory.getLog(ConfigurationWarningsApplicationContextInitializer.class);

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor(new ConfigurationWarningsPostProcessor(this.getChecks()));
    }

    protected Check[] getChecks() {
        return new Check[]{new ComponentScanPackageCheck()};
    }

    protected static final class ConfigurationWarningsPostProcessor
    implements PriorityOrdered,
    BeanDefinitionRegistryPostProcessor {
        private final Check[] checks;

        public ConfigurationWarningsPostProcessor(Check[] checks) {
            this.checks = checks;
        }

        @Override
        public int getOrder() {
            return 0x7FFFFFFE;
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        @Override
        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            for (Check check : this.checks) {
                String message2 = check.getWarning(registry);
                if (!StringUtils.hasLength(message2)) continue;
                this.warn(message2);
            }
        }

        private void warn(String message2) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("%n%n** WARNING ** : %s%n%n", message2));
            }
        }
    }

    @FunctionalInterface
    protected static interface Check {
        public String getWarning(BeanDefinitionRegistry var1);
    }

    protected static class ComponentScanPackageCheck
    implements Check {
        private static final Set<String> PROBLEM_PACKAGES;

        protected ComponentScanPackageCheck() {
        }

        @Override
        public String getWarning(BeanDefinitionRegistry registry) {
            Set<String> scannedPackages = this.getComponentScanningPackages(registry);
            List<String> problematicPackages = this.getProblematicPackages(scannedPackages);
            if (problematicPackages.isEmpty()) {
                return null;
            }
            return "Your ApplicationContext is unlikely to start due to a @ComponentScan of " + StringUtils.collectionToDelimitedString(problematicPackages, ", ") + ".";
        }

        protected Set<String> getComponentScanningPackages(BeanDefinitionRegistry registry) {
            String[] names2;
            LinkedHashSet<String> packages = new LinkedHashSet<String>();
            for (String name2 : names2 = registry.getBeanDefinitionNames()) {
                BeanDefinition definition = registry.getBeanDefinition(name2);
                if (!(definition instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition annotatedDefinition = (AnnotatedBeanDefinition)definition;
                this.addComponentScanningPackages(packages, annotatedDefinition.getMetadata());
            }
            return packages;
        }

        private void addComponentScanningPackages(Set<String> packages, AnnotationMetadata metadata) {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
            if (attributes != null) {
                this.addPackages(packages, attributes.getStringArray("value"));
                this.addPackages(packages, attributes.getStringArray("basePackages"));
                this.addClasses(packages, attributes.getStringArray("basePackageClasses"));
                if (packages.isEmpty()) {
                    packages.add(ClassUtils.getPackageName(metadata.getClassName()));
                }
            }
        }

        private void addPackages(Set<String> packages, String[] values2) {
            if (values2 != null) {
                Collections.addAll(packages, values2);
            }
        }

        private void addClasses(Set<String> packages, String[] values2) {
            if (values2 != null) {
                for (String value2 : values2) {
                    packages.add(ClassUtils.getPackageName(value2));
                }
            }
        }

        private List<String> getProblematicPackages(Set<String> scannedPackages) {
            ArrayList<String> problematicPackages = new ArrayList<String>();
            for (String scannedPackage : scannedPackages) {
                if (!this.isProblematicPackage(scannedPackage)) continue;
                problematicPackages.add(this.getDisplayName(scannedPackage));
            }
            return problematicPackages;
        }

        private boolean isProblematicPackage(String scannedPackage) {
            if (scannedPackage == null || scannedPackage.isEmpty()) {
                return true;
            }
            return PROBLEM_PACKAGES.contains(scannedPackage);
        }

        private String getDisplayName(String scannedPackage) {
            if (scannedPackage == null || scannedPackage.isEmpty()) {
                return "the default package";
            }
            return "'" + scannedPackage + "'";
        }

        static {
            HashSet<String> packages = new HashSet<String>();
            packages.add("org.springframework");
            packages.add("org");
            PROBLEM_PACKAGES = Collections.unmodifiableSet(packages);
        }
    }
}

