/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.boot.system.SystemProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class ApplicationPidFileWriter
implements ApplicationListener<SpringApplicationEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(ApplicationPidFileWriter.class);
    private static final String DEFAULT_FILE_NAME = "application.pid";
    private static final List<Property> FILE_PROPERTIES;
    private static final List<Property> FAIL_ON_WRITE_ERROR_PROPERTIES;
    private static final AtomicBoolean created;
    private int order = -2147483635;
    private final File file;
    private Class<? extends SpringApplicationEvent> triggerEventType = ApplicationPreparedEvent.class;

    public ApplicationPidFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public ApplicationPidFileWriter(String filename2) {
        this(new File(filename2));
    }

    public ApplicationPidFileWriter(File file2) {
        Assert.notNull((Object)file2, "File must not be null");
        this.file = file2;
    }

    public void setTriggerEventType(Class<? extends SpringApplicationEvent> triggerEventType) {
        Assert.notNull(triggerEventType, "Trigger event type must not be null");
        this.triggerEventType = triggerEventType;
    }

    @Override
    public void onApplicationEvent(SpringApplicationEvent event2) {
        if (this.triggerEventType.isInstance(event2) && created.compareAndSet(false, true)) {
            try {
                this.writePidFile(event2);
            }
            catch (Exception ex) {
                String message2 = String.format("Cannot create pid file %s", this.file);
                if (this.failOnWriteError(event2)) {
                    throw new IllegalStateException(message2, ex);
                }
                logger.warn(message2, ex);
            }
        }
    }

    private void writePidFile(SpringApplicationEvent event2) throws IOException {
        File pidFile = this.file;
        String override = this.getProperty(event2, FILE_PROPERTIES);
        if (override != null) {
            pidFile = new File(override);
        }
        new ApplicationPid().write(pidFile);
        pidFile.deleteOnExit();
    }

    private boolean failOnWriteError(SpringApplicationEvent event2) {
        String value2 = this.getProperty(event2, FAIL_ON_WRITE_ERROR_PROPERTIES);
        return Boolean.parseBoolean(value2);
    }

    private String getProperty(SpringApplicationEvent event2, List<Property> candidates) {
        for (Property candidate : candidates) {
            String value2 = candidate.getValue(event2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    protected static void reset() {
        created.set(false);
    }

    static {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(new SpringProperty("spring.pid.", "file"));
        properties.add(new SpringProperty("spring.", "pidfile"));
        properties.add(new SystemProperty("PIDFILE"));
        FILE_PROPERTIES = Collections.unmodifiableList(properties);
        properties = new ArrayList();
        properties.add(new SpringProperty("spring.pid.", "fail-on-write-error"));
        properties.add(new SystemProperty("PID_FAIL_ON_WRITE_ERROR"));
        FAIL_ON_WRITE_ERROR_PROPERTIES = Collections.unmodifiableList(properties);
        created = new AtomicBoolean();
    }

    private static interface Property {
        public String getValue(SpringApplicationEvent var1);
    }

    private static class SpringProperty
    implements Property {
        private final String prefix;
        private final String key;

        SpringProperty(String prefix, String key2) {
            this.prefix = prefix;
            this.key = key2;
        }

        @Override
        public String getValue(SpringApplicationEvent event2) {
            Environment environment2 = this.getEnvironment(event2);
            if (environment2 == null) {
                return null;
            }
            return environment2.getProperty(this.prefix + this.key);
        }

        private Environment getEnvironment(SpringApplicationEvent event2) {
            if (event2 instanceof ApplicationEnvironmentPreparedEvent) {
                ApplicationEnvironmentPreparedEvent environmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)event2;
                return environmentPreparedEvent.getEnvironment();
            }
            if (event2 instanceof ApplicationPreparedEvent) {
                ApplicationPreparedEvent preparedEvent = (ApplicationPreparedEvent)event2;
                return preparedEvent.getApplicationContext().getEnvironment();
            }
            if (event2 instanceof ApplicationReadyEvent) {
                ApplicationReadyEvent readyEvent = (ApplicationReadyEvent)event2;
                return readyEvent.getApplicationContext().getEnvironment();
            }
            return null;
        }
    }

    private static class SystemProperty
    implements Property {
        private final String[] properties;

        SystemProperty(String name2) {
            this.properties = new String[]{name2.toUpperCase(Locale.ENGLISH), name2.toLowerCase(Locale.ENGLISH)};
        }

        @Override
        public String getValue(SpringApplicationEvent event2) {
            return SystemProperties.get(this.properties);
        }
    }
}

