/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.util.StringUtils;

public class CloudFoundryVcapEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private final Log logger;
    private int order = -2147483643;

    public CloudFoundryVcapEnvironmentPostProcessor(DeferredLogFactory logFactory) {
        this.logger = logFactory.getLog(CloudFoundryVcapEnvironmentPostProcessor.class);
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        if (CloudPlatform.CLOUD_FOUNDRY.isActive(environment2)) {
            Properties properties = new Properties();
            JsonParser jsonParser = JsonParserFactory.getJsonParser();
            this.addWithPrefix(properties, this.getPropertiesFromApplication(environment2, jsonParser), "vcap.application.");
            this.addWithPrefix(properties, this.getPropertiesFromServices(environment2, jsonParser), "vcap.services.");
            MutablePropertySources propertySources = environment2.getPropertySources();
            if (propertySources.contains("commandLineArgs")) {
                propertySources.addAfter("commandLineArgs", new PropertiesPropertySource("vcap", properties));
            } else {
                propertySources.addFirst(new PropertiesPropertySource("vcap", properties));
            }
        }
    }

    private void addWithPrefix(Properties properties, Properties other, String prefix) {
        for (String key2 : other.stringPropertyNames()) {
            String prefixed = prefix + key2;
            properties.setProperty(prefixed, other.getProperty(key2));
        }
    }

    private Properties getPropertiesFromApplication(Environment environment2, JsonParser parser) {
        Properties properties = new Properties();
        try {
            String property = environment2.getProperty(VCAP_APPLICATION, "{}");
            Map<String, Object> map2 = parser.parseMap(property);
            this.extractPropertiesFromApplication(properties, map2);
        }
        catch (Exception ex) {
            this.logger.error("Could not parse VCAP_APPLICATION", ex);
        }
        return properties;
    }

    private Properties getPropertiesFromServices(Environment environment2, JsonParser parser) {
        Properties properties = new Properties();
        try {
            String property = environment2.getProperty(VCAP_SERVICES, "{}");
            Map<String, Object> map2 = parser.parseMap(property);
            this.extractPropertiesFromServices(properties, map2);
        }
        catch (Exception ex) {
            this.logger.error("Could not parse VCAP_SERVICES", ex);
        }
        return properties;
    }

    private void extractPropertiesFromApplication(Properties properties, Map<String, Object> map2) {
        if (map2 != null) {
            this.flatten(properties, map2, "");
        }
    }

    private void extractPropertiesFromServices(Properties properties, Map<String, Object> map2) {
        if (map2 != null) {
            for (Object services : map2.values()) {
                List list2 = (List)services;
                for (Object object : list2) {
                    Map service = (Map)object;
                    String key2 = (String)service.get("name");
                    if (key2 == null) {
                        key2 = (String)service.get("label");
                    }
                    this.flatten(properties, service, key2);
                }
            }
        }
    }

    private void flatten(Properties properties, Map<String, Object> input, String path2) {
        input.forEach((key2, value2) -> {
            String name2 = this.getPropertyName(path2, (String)key2);
            if (value2 instanceof Map) {
                this.flatten(properties, (Map)value2, name2);
            } else if (value2 instanceof Collection) {
                Collection collection = (Collection)value2;
                properties.put(name2, StringUtils.collectionToCommaDelimitedString(collection));
                int count2 = 0;
                for (Object item : collection) {
                    String itemKey = "[" + count2++ + "]";
                    this.flatten(properties, Collections.singletonMap(itemKey, item), name2);
                }
            } else if (value2 instanceof String) {
                properties.put(name2, value2);
            } else if (value2 instanceof Number) {
                properties.put(name2, value2.toString());
            } else if (value2 instanceof Boolean) {
                properties.put(name2, value2.toString());
            } else {
                properties.put(name2, value2 != null ? value2 : "");
            }
        });
    }

    private String getPropertyName(String path2, String key2) {
        if (!StringUtils.hasText(path2)) {
            return key2;
        }
        if (key2.startsWith("[")) {
            return path2 + key2;
        }
        return path2 + "." + key2;
    }
}

