/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.builder;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class ParentContextApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private int order = Integer.MIN_VALUE;
    private final ApplicationContext parent;

    public ParentContextApplicationContextInitializer(ApplicationContext parent) {
        this.parent = parent;
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (applicationContext != this.parent) {
            applicationContext.setParent(this.parent);
            applicationContext.addApplicationListener(EventPublisher.INSTANCE);
        }
    }

    private static final class EventPublisher
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private static final EventPublisher INSTANCE = new EventPublisher();

        private EventPublisher() {
        }

        @Override
        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        @Override
        public void onApplicationEvent(ContextRefreshedEvent event2) {
            ApplicationContext context = event2.getApplicationContext();
            if (context instanceof ConfigurableApplicationContext && context == event2.getSource()) {
                context.publishEvent(new ParentContextAvailableEvent((ConfigurableApplicationContext)context));
            }
        }
    }

    public static class ParentContextAvailableEvent
    extends ApplicationEvent {
        public ParentContextAvailableEvent(ConfigurableApplicationContext applicationContext) {
            super(applicationContext);
        }

        public ConfigurableApplicationContext getApplicationContext() {
            return (ConfigurableApplicationContext)this.getSource();
        }
    }
}

