/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public class ApplicationAvailabilityBean
implements ApplicationAvailability,
ApplicationListener<AvailabilityChangeEvent<?>> {
    private final Map<Class<? extends AvailabilityState>, AvailabilityChangeEvent<?>> events = new ConcurrentHashMap();
    private final Log logger;

    public ApplicationAvailabilityBean() {
        this(LogFactory.getLog(ApplicationAvailabilityBean.class));
    }

    ApplicationAvailabilityBean(Log logger) {
        this.logger = logger;
    }

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType, S defaultState) {
        Assert.notNull(stateType, "StateType must not be null");
        Assert.notNull(defaultState, "DefaultState must not be null");
        S state2 = this.getState(stateType);
        return state2 != null ? state2 : defaultState;
    }

    @Override
    public <S extends AvailabilityState> S getState(Class<S> stateType) {
        AvailabilityChangeEvent<S> event2 = this.getLastChangeEvent(stateType);
        return event2 != null ? (S)event2.getState() : null;
    }

    @Override
    public <S extends AvailabilityState> AvailabilityChangeEvent<S> getLastChangeEvent(Class<S> stateType) {
        return this.events.get(stateType);
    }

    @Override
    public void onApplicationEvent(AvailabilityChangeEvent<?> event2) {
        Class<? extends AvailabilityState> type2 = this.getStateType((AvailabilityState)event2.getState());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getLogMessage(type2, event2));
        }
        this.events.put(type2, event2);
    }

    private <S extends AvailabilityState> Object getLogMessage(Class<S> type2, AvailabilityChangeEvent<?> event2) {
        AvailabilityChangeEvent<S> lastChangeEvent = this.getLastChangeEvent(type2);
        StringBuilder message2 = new StringBuilder("Application availability state " + type2.getSimpleName() + " changed");
        message2.append((String)(lastChangeEvent != null ? " from " + lastChangeEvent.getState() : ""));
        message2.append(" to " + event2.getState());
        message2.append(this.getSourceDescription(event2.getSource()));
        return message2;
    }

    private String getSourceDescription(Object source2) {
        if (source2 == null || source2 instanceof ApplicationEventPublisher) {
            return "";
        }
        return ": " + (source2 instanceof Throwable ? source2 : source2.getClass().getName());
    }

    private Class<? extends AvailabilityState> getStateType(AvailabilityState state2) {
        Class<Object> clazz;
        if (state2 instanceof Enum) {
            Enum enumState = (Enum)((Object)state2);
            clazz = enumState.getDeclaringClass();
        } else {
            clazz = state2.getClass();
        }
        Class<?> type2 = clazz;
        return type2;
    }
}

