/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.WebListenerRegistrar;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.servlet.server.CookieSameSiteSupplier;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

public class ServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;
    private final List<WebListenerRegistrar> webListenerRegistrars;
    private final List<CookieSameSiteSupplier> cookieSameSiteSuppliers;
    private final SslBundles sslBundles;

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this(serverProperties, Collections.emptyList());
    }

    public ServletWebServerFactoryCustomizer(ServerProperties serverProperties, List<WebListenerRegistrar> webListenerRegistrars) {
        this(serverProperties, webListenerRegistrars, null, null);
    }

    ServletWebServerFactoryCustomizer(ServerProperties serverProperties, List<WebListenerRegistrar> webListenerRegistrars, List<CookieSameSiteSupplier> cookieSameSiteSuppliers, SslBundles sslBundles) {
        this.serverProperties = serverProperties;
        this.webListenerRegistrars = webListenerRegistrars;
        this.cookieSameSiteSuppliers = cookieSameSiteSuppliers;
        this.sslBundles = sslBundles;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableServletWebServerFactory factory) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map2.from(this.serverProperties::getPort).to(factory::setPort);
        map2.from(this.serverProperties::getAddress).to(factory::setAddress);
        map2.from(this.serverProperties.getServlet()::getContextPath).to(factory::setContextPath);
        map2.from(this.serverProperties.getServlet()::getApplicationDisplayName).to(factory::setDisplayName);
        map2.from(this.serverProperties.getServlet()::isRegisterDefaultServlet).to(factory::setRegisterDefaultServlet);
        map2.from(this.serverProperties.getServlet()::getSession).to(factory::setSession);
        map2.from(this.serverProperties::getSsl).to(factory::setSsl);
        map2.from(this.serverProperties.getServlet()::getJsp).to(factory::setJsp);
        map2.from(this.serverProperties::getCompression).to(factory::setCompression);
        map2.from(this.serverProperties::getHttp2).to(factory::setHttp2);
        map2.from(this.serverProperties::getServerHeader).to(factory::setServerHeader);
        map2.from(this.serverProperties.getServlet()::getContextParameters).to(factory::setInitParameters);
        map2.from(this.serverProperties.getShutdown()).to(factory::setShutdown);
        map2.from(() -> this.sslBundles).to(factory::setSslBundles);
        map2.from(() -> this.cookieSameSiteSuppliers).whenNot(CollectionUtils::isEmpty).to(factory::setCookieSameSiteSuppliers);
        map2.from(this.serverProperties::getMimeMappings).to(factory::addMimeMappings);
        this.webListenerRegistrars.forEach(registrar -> registrar.register(factory));
    }
}

