/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.net.http.HttpClient;
import javax.net.ssl.SSLParameters;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.reactive.JdkClientHttpConnector;

class JdkClientHttpConnectorFactory
implements ClientHttpConnectorFactory<JdkClientHttpConnector> {
    JdkClientHttpConnectorFactory() {
    }

    @Override
    public JdkClientHttpConnector createClientHttpConnector(SslBundle sslBundle) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (sslBundle != null) {
            SslOptions options2 = sslBundle.getOptions();
            builder.sslContext(sslBundle.createSslContext());
            SSLParameters parameters2 = new SSLParameters();
            parameters2.setCipherSuites(options2.getCiphers());
            parameters2.setProtocols(options2.getEnabledProtocols());
            builder.sslParameters(parameters2);
        }
        return new JdkClientHttpConnector(builder.build());
    }
}

