/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.nio.ssl.BasicClientTlsStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;

class HttpComponentsClientHttpConnectorFactory
implements ClientHttpConnectorFactory<HttpComponentsClientHttpConnector> {
    HttpComponentsClientHttpConnectorFactory() {
    }

    @Override
    public HttpComponentsClientHttpConnector createClientHttpConnector(SslBundle sslBundle) {
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().useSystemProperties();
        if (sslBundle != null) {
            SslOptions options2 = sslBundle.getOptions();
            SSLContext sslContext = sslBundle.createSslContext();
            SSLSessionVerifier sessionVerifier = (endpoint, sslEngine) -> {
                if (options2.getCiphers() != null) {
                    sslEngine.setEnabledCipherSuites(options2.getCiphers());
                }
                if (options2.getEnabledProtocols() != null) {
                    sslEngine.setEnabledProtocols(options2.getEnabledProtocols());
                }
                return null;
            };
            BasicClientTlsStrategy tlsStrategy = new BasicClientTlsStrategy(sslContext, sessionVerifier);
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy((TlsStrategy)tlsStrategy).build();
            builder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
        }
        return new HttpComponentsClientHttpConnector(builder.build());
    }
}

