/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.ReactiveMultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.multipart.DefaultPartHttpMessageReader;
import org.springframework.http.codec.multipart.PartEventHttpMessageReader;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@AutoConfiguration
@ConditionalOnClass(value={DefaultPartHttpMessageReader.class, WebFluxConfigurer.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={ReactiveMultipartProperties.class})
public class ReactiveMultipartAutoConfiguration {
    @Bean
    @Order(value=0)
    CodecCustomizer defaultPartHttpMessageReaderCustomizer(ReactiveMultipartProperties multipartProperties) {
        return configurer -> configurer.defaultCodecs().configureDefaultCodec(codec -> {
            if (codec instanceof DefaultPartHttpMessageReader) {
                DefaultPartHttpMessageReader defaultPartHttpMessageReader = (DefaultPartHttpMessageReader)codec;
                PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map2.from(multipartProperties::getMaxInMemorySize).asInt(DataSize::toBytes).to(defaultPartHttpMessageReader::setMaxInMemorySize);
                map2.from(multipartProperties::getMaxHeadersSize).asInt(DataSize::toBytes).to(defaultPartHttpMessageReader::setMaxHeadersSize);
                map2.from(multipartProperties::getMaxDiskUsagePerPart).as(DataSize::toBytes).to(defaultPartHttpMessageReader::setMaxDiskUsagePerPart);
                map2.from(multipartProperties::getMaxParts).to(defaultPartHttpMessageReader::setMaxParts);
                map2.from(multipartProperties::getFileStorageDirectory).as(x$0 -> Paths.get(x$0, new String[0])).to(dir -> this.configureFileStorageDirectory(defaultPartHttpMessageReader, (Path)dir));
                map2.from(multipartProperties::getHeadersCharset).to(defaultPartHttpMessageReader::setHeadersCharset);
            } else if (codec instanceof PartEventHttpMessageReader) {
                PartEventHttpMessageReader partEventHttpMessageReader = (PartEventHttpMessageReader)codec;
                PropertyMapper map3 = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map3.from(multipartProperties::getMaxInMemorySize).asInt(DataSize::toBytes).to(partEventHttpMessageReader::setMaxInMemorySize);
                map3.from(multipartProperties::getMaxHeadersSize).asInt(DataSize::toBytes).to(partEventHttpMessageReader::setMaxHeadersSize);
                map3.from(multipartProperties::getMaxDiskUsagePerPart).as(DataSize::toBytes).to(partEventHttpMessageReader::setMaxPartSize);
                map3.from(multipartProperties::getMaxParts).to(partEventHttpMessageReader::setMaxParts);
                map3.from(multipartProperties::getHeadersCharset).to(partEventHttpMessageReader::setHeadersCharset);
            }
        });
    }

    private void configureFileStorageDirectory(DefaultPartHttpMessageReader defaultPartHttpMessageReader, Path fileStorageDirectory) {
        try {
            defaultPartHttpMessageReader.setFileStorageDirectory(fileStorageDirectory);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to configure multipart file storage directory", ex);
        }
    }
}

