/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http2.Http2Protocol;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

public class TomcatWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;

    public TomcatWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat properties = this.serverProperties.getTomcat();
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map2.from(properties::getBasedir).to(factory::setBaseDirectory);
        map2.from(properties::getBackgroundProcessorDelay).as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        ServerProperties.Tomcat.Threads threadProperties = properties.getThreads();
        map2.from(threadProperties::getMax).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, (int)maxThreads));
        map2.from(threadProperties::getMinSpare).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        map2.from(threadProperties::getMaxQueueCapacity).when(this::isPositive).to(maxQueueCapacity -> this.customizeMaxQueueCapacity(factory, (int)maxQueueCapacity));
        map2.from(this.serverProperties.getMaxHttpRequestHeaderSize()).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpRequestHeaderSize -> this.customizeMaxHttpRequestHeaderSize(factory, (int)maxHttpRequestHeaderSize));
        map2.from(properties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(maxHttpResponseHeaderSize -> this.customizeMaxHttpResponseHeaderSize(factory, (int)maxHttpResponseHeaderSize));
        map2.from(properties::getMaxSwallowSize).asInt(DataSize::toBytes).to(maxSwallowSize -> this.customizeMaxSwallowSize(factory, (int)maxSwallowSize));
        map2.from(properties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(maxHttpFormPostSize -> maxHttpFormPostSize != 0).to(maxHttpFormPostSize -> this.customizeMaxHttpFormPostSize(factory, (int)maxHttpFormPostSize));
        map2.from(properties::getAccesslog).when(ServerProperties.Tomcat.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory));
        map2.from(properties::getUriEncoding).to(factory::setUriEncoding);
        map2.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        map2.from(properties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        map2.from(properties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        map2.from(properties::getProcessorCache).to(processorCache -> this.customizeProcessorCache(factory, (int)processorCache));
        map2.from(properties::getKeepAliveTimeout).to(keepAliveTimeout -> this.customizeKeepAliveTimeout(factory, (Duration)keepAliveTimeout));
        map2.from(properties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        map2.from(properties::getRelaxedPathChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedPathChars(factory, (String)relaxedChars));
        map2.from(properties::getRelaxedQueryChars).as(this::joinCharacters).whenHasText().to(relaxedChars -> this.customizeRelaxedQueryChars(factory, (String)relaxedChars));
        map2.from(properties::isRejectIllegalHeader).to(rejectIllegalHeader -> this.customizeRejectIllegalHeader(factory, (boolean)rejectIllegalHeader));
        this.customizeStaticResources(factory);
        this.customizeErrorReportValve(this.serverProperties.getError(), factory);
    }

    private boolean isPositive(int value2) {
        return value2 > 0;
    }

    private void customizeMaxThreads(ConfigurableTomcatWebServerFactory factory, int maxThreads) {
        this.customizeHandler(factory, maxThreads, AbstractProtocol.class, AbstractProtocol::setMaxThreads);
    }

    private void customizeMinThreads(ConfigurableTomcatWebServerFactory factory, int minSpareThreads) {
        this.customizeHandler(factory, minSpareThreads, AbstractProtocol.class, AbstractProtocol::setMinSpareThreads);
    }

    private void customizeMaxQueueCapacity(ConfigurableTomcatWebServerFactory factory, int maxQueueCapacity) {
        this.customizeHandler(factory, maxQueueCapacity, AbstractProtocol.class, AbstractProtocol::setMaxQueueSize);
    }

    private void customizeAcceptCount(ConfigurableTomcatWebServerFactory factory, int acceptCount) {
        this.customizeHandler(factory, acceptCount, AbstractProtocol.class, AbstractProtocol::setAcceptCount);
    }

    private void customizeProcessorCache(ConfigurableTomcatWebServerFactory factory, int processorCache) {
        this.customizeHandler(factory, processorCache, AbstractProtocol.class, AbstractProtocol::setProcessorCache);
    }

    private void customizeKeepAliveTimeout(ConfigurableTomcatWebServerFactory factory, Duration keepAliveTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                Http2Protocol protocol2 = (Http2Protocol)upgradeProtocol;
                protocol2.setKeepAliveTimeout(keepAliveTimeout.toMillis());
            }
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol3 = (AbstractProtocol)handler;
                protocol3.setKeepAliveTimeout((int)keepAliveTimeout.toMillis());
            }
        });
    }

    private void customizeMaxKeepAliveRequests(ConfigurableTomcatWebServerFactory factory, int maxKeepAliveRequests) {
        this.customizeHandler(factory, maxKeepAliveRequests, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxKeepAliveRequests);
    }

    private void customizeMaxConnections(ConfigurableTomcatWebServerFactory factory, int maxConnections) {
        this.customizeHandler(factory, maxConnections, AbstractProtocol.class, AbstractProtocol::setMaxConnections);
    }

    private void customizeConnectionTimeout(ConfigurableTomcatWebServerFactory factory, Duration connectionTimeout) {
        this.customizeHandler(factory, (int)connectionTimeout.toMillis(), AbstractProtocol.class, AbstractProtocol::setConnectionTimeout);
    }

    private void customizeRelaxedPathChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedPathChars", relaxedChars));
    }

    private void customizeRelaxedQueryChars(ConfigurableTomcatWebServerFactory factory, String relaxedChars) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("relaxedQueryChars", relaxedChars));
    }

    private void customizeRejectIllegalHeader(ConfigurableTomcatWebServerFactory factory, boolean rejectIllegalHeader) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol2 = (AbstractHttp11Protocol)handler;
                protocol2.setRejectIllegalHeader(rejectIllegalHeader);
            }
        });
    }

    private String joinCharacters(List<Character> content) {
        return content.stream().map(String::valueOf).collect(Collectors.joining());
    }

    private void customizeRemoteIpValve(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat.Remoteip remoteIpProperties = this.serverProperties.getTomcat().getRemoteip();
        String protocolHeader = remoteIpProperties.getProtocolHeader();
        String remoteIpHeader = remoteIpProperties.getRemoteIpHeader();
        if (StringUtils.hasText(protocolHeader) || StringUtils.hasText(remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength(protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength(remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setTrustedProxies(remoteIpProperties.getTrustedProxies());
            valve.setInternalProxies(remoteIpProperties.getInternalProxies());
            try {
                valve.setHostHeader(remoteIpProperties.getHostHeader());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            valve.setPortHeader(remoteIpProperties.getPortHeader());
            valve.setProtocolHeaderHttpsValue(remoteIpProperties.getProtocolHeaderHttpsValue());
            factory.addEngineValves(valve);
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy() == ServerProperties.ForwardHeadersStrategy.NATIVE;
    }

    private void customizeMaxHttpRequestHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpRequestHeaderSize) {
        this.customizeHandler(factory, maxHttpRequestHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpRequestHeaderSize);
    }

    private void customizeMaxHttpResponseHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpResponseHeaderSize) {
        this.customizeHandler(factory, maxHttpResponseHeaderSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxHttpResponseHeaderSize);
    }

    private void customizeMaxSwallowSize(ConfigurableTomcatWebServerFactory factory, int maxSwallowSize) {
        this.customizeHandler(factory, maxSwallowSize, AbstractHttp11Protocol.class, AbstractHttp11Protocol::setMaxSwallowSize);
    }

    private <T extends ProtocolHandler> void customizeHandler(ConfigurableTomcatWebServerFactory factory, int value2, Class<T> type2, ObjIntConsumer<T> consumer) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (type2.isAssignableFrom(handler.getClass())) {
                consumer.accept((ProtocolHandler)type2.cast(handler), value2);
            }
        });
    }

    private void customizeMaxHttpFormPostSize(ConfigurableTomcatWebServerFactory factory, int maxHttpFormPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpFormPostSize));
    }

    private void customizeAccessLog(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat tomcatProperties = this.serverProperties.getTomcat();
        AccessLogValve valve = new AccessLogValve();
        PropertyMapper map2 = PropertyMapper.get();
        ServerProperties.Tomcat.Accesslog accessLogConfig = tomcatProperties.getAccesslog();
        map2.from(accessLogConfig.getConditionIf()).to(valve::setConditionIf);
        map2.from(accessLogConfig.getConditionUnless()).to(valve::setConditionUnless);
        map2.from(accessLogConfig.getPattern()).to(valve::setPattern);
        map2.from(accessLogConfig.getDirectory()).to(valve::setDirectory);
        map2.from(accessLogConfig.getPrefix()).to(valve::setPrefix);
        map2.from(accessLogConfig.getSuffix()).to(valve::setSuffix);
        map2.from(accessLogConfig.getEncoding()).whenHasText().to(valve::setEncoding);
        map2.from(accessLogConfig.getLocale()).whenHasText().to(valve::setLocale);
        map2.from(accessLogConfig.isCheckExists()).to(valve::setCheckExists);
        map2.from(accessLogConfig.isRotate()).to(valve::setRotatable);
        map2.from(accessLogConfig.isRenameOnRotate()).to(valve::setRenameOnRotate);
        map2.from(accessLogConfig.getMaxDays()).to(valve::setMaxDays);
        map2.from(accessLogConfig.getFileDateFormat()).to(valve::setFileDateFormat);
        map2.from(accessLogConfig.isIpv6Canonical()).to(valve::setIpv6Canonical);
        map2.from(accessLogConfig.isRequestAttributesEnabled()).to(valve::setRequestAttributesEnabled);
        map2.from(accessLogConfig.isBuffered()).to(valve::setBuffered);
        factory.addEngineValves(valve);
    }

    private void customizeStaticResources(ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat.Resource resource = this.serverProperties.getTomcat().getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event2 -> {
            if (event2.getType().equals("configure_start")) {
                context.getResources().setCachingAllowed(resource.isAllowCaching());
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error2, ConfigurableTomcatWebServerFactory factory) {
        if (error2.getIncludeStacktrace() == ErrorProperties.IncludeAttribute.NEVER) {
            factory.addContextCustomizers(context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve(valve);
            });
        }
    }
}

