/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;

public class NettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public NettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(NettyReactiveWebServerFactory factory) {
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
        map2.from(nettyProperties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        map2.from(nettyProperties::getIdleTimeout).to(idleTimeout -> this.customizeIdleTimeout(factory, (Duration)idleTimeout));
        map2.from(nettyProperties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        if (this.serverProperties.getHttp2() != null && this.serverProperties.getHttp2().isEnabled()) {
            map2.from(this.serverProperties.getMaxHttpRequestHeaderSize()).to(size2 -> this.customizeHttp2MaxHeaderSize(factory, size2.toBytes()));
        }
        this.customizeRequestDecoder(factory, map2);
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeConnectionTimeout(NettyReactiveWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(httpServer -> (HttpServer)httpServer.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())));
    }

    private void customizeRequestDecoder(NettyReactiveWebServerFactory factory, PropertyMapper propertyMapper) {
        factory.addServerCustomizers(httpServer -> httpServer.httpRequestDecoder(httpRequestDecoderSpec -> {
            propertyMapper.from(this.serverProperties.getMaxHttpRequestHeaderSize()).to(maxHttpRequestHeader -> httpRequestDecoderSpec.maxHeaderSize((int)maxHttpRequestHeader.toBytes()));
            ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
            propertyMapper.from(nettyProperties.getMaxInitialLineLength()).to(maxInitialLineLength -> httpRequestDecoderSpec.maxInitialLineLength((int)maxInitialLineLength.toBytes()));
            propertyMapper.from(nettyProperties.getH2cMaxContentLength()).to(h2cMaxContentLength -> httpRequestDecoderSpec.h2cMaxContentLength((int)h2cMaxContentLength.toBytes()));
            propertyMapper.from(nettyProperties.getInitialBufferSize()).to(initialBufferSize -> httpRequestDecoderSpec.initialBufferSize((int)initialBufferSize.toBytes()));
            propertyMapper.from(nettyProperties.isValidateHeaders()).to(arg_0 -> ((HttpRequestDecoderSpec)httpRequestDecoderSpec).validateHeaders(arg_0));
            return httpRequestDecoderSpec;
        }));
    }

    private void customizeIdleTimeout(NettyReactiveWebServerFactory factory, Duration idleTimeout) {
        factory.addServerCustomizers(httpServer -> httpServer.idleTimeout(idleTimeout));
    }

    private void customizeMaxKeepAliveRequests(NettyReactiveWebServerFactory factory, int maxKeepAliveRequests) {
        factory.addServerCustomizers(httpServer -> httpServer.maxKeepAliveRequests(maxKeepAliveRequests));
    }

    private void customizeHttp2MaxHeaderSize(NettyReactiveWebServerFactory factory, long size2) {
        factory.addServerCustomizers(httpServer -> httpServer.http2Settings(settings -> settings.maxHeaderListSize(size2)));
    }
}

