/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

class OnEnabledResourceChainCondition
extends SpringBootCondition {
    private static final String WEBJAR_ASSET_LOCATOR = "org.webjars.WebJarAssetLocator";

    OnEnabledResourceChainCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableEnvironment environment2 = (ConfigurableEnvironment)context.getEnvironment();
        boolean fixed = this.getEnabledProperty(environment2, "strategy.fixed.", false);
        boolean content = this.getEnabledProperty(environment2, "strategy.content.", false);
        Boolean chain2 = this.getEnabledProperty(environment2, "", null);
        Boolean match2 = WebProperties.Resources.Chain.getEnabled(fixed, content, chain2);
        ConditionMessage.Builder message2 = ConditionMessage.forCondition(ConditionalOnEnabledResourceChain.class, new Object[0]);
        if (match2 == null) {
            if (ClassUtils.isPresent(WEBJAR_ASSET_LOCATOR, this.getClass().getClassLoader())) {
                return ConditionOutcome.match(message2.found("class").items(WEBJAR_ASSET_LOCATOR));
            }
            return ConditionOutcome.noMatch(message2.didNotFind("class").items(WEBJAR_ASSET_LOCATOR));
        }
        if (match2.booleanValue()) {
            return ConditionOutcome.match(message2.because("enabled"));
        }
        return ConditionOutcome.noMatch(message2.because("disabled"));
    }

    private Boolean getEnabledProperty(ConfigurableEnvironment environment2, String key2, Boolean defaultValue) {
        String name2 = "spring.web.resources.chain." + key2 + "enabled";
        return environment2.getProperty(name2, Boolean.class, defaultValue);
    }
}

