/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import jakarta.servlet.DispatcherType;
import java.util.LinkedHashMap;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.TemplateEngineConfigurations;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.util.MimeType;
import org.springframework.util.unit.DataSize;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.thymeleaf.extras.springsecurity6.dialect.SpringSecurityDialect;
import org.thymeleaf.spring6.ISpringTemplateEngine;
import org.thymeleaf.spring6.ISpringWebFluxTemplateEngine;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.spring6.view.reactive.ThymeleafReactiveViewResolver;
import org.thymeleaf.templatemode.TemplateMode;

@AutoConfiguration(after={WebMvcAutoConfiguration.class, WebFluxAutoConfiguration.class})
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={TemplateMode.class, SpringTemplateEngine.class})
@Import(value={TemplateEngineConfigurations.ReactiveTemplateEngineConfiguration.class, TemplateEngineConfigurations.DefaultTemplateEngineConfiguration.class})
public class ThymeleafAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SpringSecurityDialect.class, CsrfToken.class})
    static class ThymeleafSecurityDialectConfiguration {
        ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DataAttributeDialect.class})
    static class DataAttributeDialectConfiguration {
        DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        DataAttributeDialect dialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LayoutDialect.class})
    static class ThymeleafWebLayoutConfiguration {
        ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    static class ThymeleafWebFluxConfiguration {
        ThymeleafWebFluxConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"thymeleafReactiveViewResolver"})
        ThymeleafReactiveViewResolver thymeleafViewResolver(ISpringWebFluxTemplateEngine templateEngine, ThymeleafProperties properties) {
            ThymeleafReactiveViewResolver resolver = new ThymeleafReactiveViewResolver();
            resolver.setTemplateEngine(templateEngine);
            this.mapProperties(properties, resolver);
            this.mapReactiveProperties(properties.getReactive(), resolver);
            resolver.setOrder(0x7FFFFFFA);
            return resolver;
        }

        private void mapProperties(ThymeleafProperties properties, ThymeleafReactiveViewResolver resolver) {
            PropertyMapper map2 = PropertyMapper.get();
            map2.from(properties::getEncoding).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setDefaultCharset(arg_0));
            resolver.setExcludedViewNames(properties.getExcludedViewNames());
            resolver.setViewNames(properties.getViewNames());
        }

        private void mapReactiveProperties(ThymeleafProperties.Reactive properties, ThymeleafReactiveViewResolver resolver) {
            PropertyMapper map2 = PropertyMapper.get();
            map2.from(properties::getMediaTypes).whenNonNull().to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setSupportedMediaTypes(arg_0));
            map2.from(properties::getMaxChunkSize).asInt(DataSize::toBytes).when(size2 -> size2 > 0).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setResponseMaxChunkSizeBytes(arg_0));
            map2.from(properties::getFullModeViewNames).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setFullModeViewNames(arg_0));
            map2.from(properties::getChunkedModeViewNames).to(arg_0 -> ((ThymeleafReactiveViewResolver)resolver).setChunkedModeViewNames(arg_0));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
    static class ThymeleafWebMvcConfiguration {
        ThymeleafWebMvcConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledResourceChain
        @ConditionalOnMissingFilterBean(value={ResourceUrlEncodingFilter.class})
        FilterRegistrationBean<ResourceUrlEncodingFilter> resourceUrlEncodingFilter() {
            FilterRegistrationBean<ResourceUrlEncodingFilter> registration = new FilterRegistrationBean<ResourceUrlEncodingFilter>(new ResourceUrlEncodingFilter(), new ServletRegistrationBean[0]);
            registration.setDispatcherTypes(DispatcherType.REQUEST, DispatcherType.ERROR);
            return registration;
        }

        @Configuration(proxyBeanMethods=false)
        static class ThymeleafViewResolverConfiguration {
            ThymeleafViewResolverConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
            ThymeleafViewResolver thymeleafViewResolver(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
                ThymeleafViewResolver resolver = new ThymeleafViewResolver();
                resolver.setTemplateEngine((ISpringTemplateEngine)templateEngine);
                resolver.setCharacterEncoding(properties.getEncoding().name());
                resolver.setContentType(this.appendCharset(properties.getServlet().getContentType(), resolver.getCharacterEncoding()));
                resolver.setProducePartialOutputWhileProcessing(properties.getServlet().isProducePartialOutputWhileProcessing());
                resolver.setExcludedViewNames(properties.getExcludedViewNames());
                resolver.setViewNames(properties.getViewNames());
                resolver.setOrder(0x7FFFFFFA);
                resolver.setCache(properties.isCache());
                return resolver;
            }

            private String appendCharset(MimeType type2, String charset) {
                if (type2.getCharset() != null) {
                    return type2.toString();
                }
                LinkedHashMap<String, String> parameters2 = new LinkedHashMap<String, String>();
                parameters2.put("charset", charset);
                parameters2.putAll(type2.getParameters());
                return new MimeType(type2, parameters2).toString();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
    static class DefaultTemplateResolverConfiguration {
        private static final Log logger = LogFactory.getLog(DefaultTemplateResolverConfiguration.class);
        private final ThymeleafProperties properties;
        private final ApplicationContext applicationContext;

        DefaultTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
            this.properties = properties;
            this.applicationContext = applicationContext;
            this.checkTemplateLocationExists();
        }

        private void checkTemplateLocationExists() {
            TemplateLocation location;
            boolean checkTemplateLocation = this.properties.isCheckTemplateLocation();
            if (checkTemplateLocation && !(location = new TemplateLocation(this.properties.getPrefix())).exists(this.applicationContext)) {
                logger.warn("Cannot find template location: " + location + " (please add some templates, check your Thymeleaf configuration, or set spring.thymeleaf.check-template-location=false)");
            }
        }

        @Bean
        SpringResourceTemplateResolver defaultTemplateResolver() {
            SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
            resolver.setApplicationContext(this.applicationContext);
            resolver.setPrefix(this.properties.getPrefix());
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setTemplateMode(this.properties.getMode());
            if (this.properties.getEncoding() != null) {
                resolver.setCharacterEncoding(this.properties.getEncoding().name());
            }
            resolver.setCacheable(this.properties.isCache());
            Integer order2 = this.properties.getTemplateResolverOrder();
            if (order2 != null) {
                resolver.setOrder(order2);
            }
            resolver.setCheckExistence(this.properties.isCheckTemplate());
            return resolver;
        }
    }
}

