/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.sql.init;

import java.util.Locale;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.sql.init.DatabaseInitializationMode;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class OnDatabaseInitializationCondition
extends SpringBootCondition {
    private final String name;
    private final String[] propertyNames;

    public OnDatabaseInitializationCondition(String name2, String ... propertyNames) {
        this.name = name2;
        this.propertyNames = propertyNames;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment2 = context.getEnvironment();
        String propertyName = this.getConfiguredProperty(environment2);
        DatabaseInitializationMode mode2 = this.getDatabaseInitializationMode(environment2, propertyName);
        boolean match2 = this.match(mode2);
        String messagePrefix = propertyName != null ? propertyName : "default value";
        return new ConditionOutcome(match2, ConditionMessage.forCondition(this.name + "Database Initialization", new Object[0]).because(messagePrefix + " is " + mode2));
    }

    private boolean match(DatabaseInitializationMode mode2) {
        return !mode2.equals((Object)DatabaseInitializationMode.NEVER);
    }

    private DatabaseInitializationMode getDatabaseInitializationMode(Environment environment2, String propertyName) {
        String candidate;
        if (StringUtils.hasText(propertyName) && StringUtils.hasText(candidate = environment2.getProperty(propertyName, "embedded").toUpperCase(Locale.ENGLISH))) {
            return DatabaseInitializationMode.valueOf(candidate);
        }
        return DatabaseInitializationMode.EMBEDDED;
    }

    private String getConfiguredProperty(Environment environment2) {
        for (String propertyName : this.propertyNames) {
            if (!environment2.containsProperty(propertyName)) continue;
            return propertyName;
        }
        return null;
    }
}

