/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.service.connection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactoryNotFoundException;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsNotFoundException;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

public class ConnectionDetailsFactories {
    private static final Log logger = LogFactory.getLog(ConnectionDetailsFactories.class);
    private final List<Registration<?, ?>> registrations = new ArrayList();

    public ConnectionDetailsFactories() {
        this(SpringFactoriesLoader.forDefaultResourceLocation(ConnectionDetailsFactory.class.getClassLoader()));
    }

    ConnectionDetailsFactories(SpringFactoriesLoader loader) {
        List<ConnectionDetailsFactory> factories = loader.load(ConnectionDetailsFactory.class, SpringFactoriesLoader.FailureHandler.logging(logger));
        Stream<Registration> registrations = factories.stream().map(Registration::get);
        registrations.filter(Objects::nonNull).forEach(this.registrations::add);
    }

    public <S> Map<Class<?>, ConnectionDetails> getConnectionDetails(S source2, boolean required) throws ConnectionDetailsFactoryNotFoundException, ConnectionDetailsNotFoundException {
        List<Registration<S, ?>> registrations = this.getRegistrations(source2, required);
        LinkedHashMap result2 = new LinkedHashMap();
        for (Registration<S, ?> registration : registrations) {
            Object connectionDetails = registration.factory().getConnectionDetails(source2);
            if (connectionDetails == null) continue;
            Class<?> connectionDetailsType = registration.connectionDetailsType();
            ConnectionDetails previous = (ConnectionDetails)result2.put(connectionDetailsType, connectionDetails);
            Assert.state(previous == null, () -> "Duplicate connection details supplied for %s".formatted(connectionDetailsType.getName()));
        }
        if (required && result2.isEmpty()) {
            throw new ConnectionDetailsNotFoundException(source2);
        }
        return Map.copyOf(result2);
    }

    <S> List<Registration<S, ?>> getRegistrations(S source2, boolean required) {
        Class<?> sourceType = source2.getClass();
        ArrayList<Registration> result2 = new ArrayList<Registration>();
        for (Registration<?, ?> candidate : this.registrations) {
            if (!candidate.sourceType().isAssignableFrom(sourceType)) continue;
            result2.add(candidate);
        }
        if (required && result2.isEmpty()) {
            throw new ConnectionDetailsFactoryNotFoundException(source2);
        }
        result2.sort(Comparator.comparing(Registration::factory, AnnotationAwareOrderComparator.INSTANCE));
        return List.copyOf(result2);
    }

    record Registration<S, D extends ConnectionDetails>(Class<S> sourceType, Class<D> connectionDetailsType, ConnectionDetailsFactory<S, D> factory) {
        private static <S, D extends ConnectionDetails> Registration<S, D> get(ConnectionDetailsFactory<S, D> factory) {
            ResolvableType type2 = ResolvableType.forClass(ConnectionDetailsFactory.class, factory.getClass());
            Class<?>[] generics = type2.resolveGenerics();
            Class<?> sourceType = generics[0];
            Class<?> connectionDetailsType = generics[1];
            return sourceType != null && connectionDetailsType != null ? new Registration(sourceType, connectionDetailsType, factory) : null;
        }
    }
}

