/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.rsocket;

import java.net.InetAddress;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="spring.rsocket")
public class RSocketProperties {
    @NestedConfigurationProperty
    private final Server server = new Server();

    public Server getServer() {
        return this.server;
    }

    public static class Server {
        private Integer port;
        private InetAddress address;
        private RSocketServer.Transport transport = RSocketServer.Transport.TCP;
        private String mappingPath;
        private DataSize fragmentSize;
        @NestedConfigurationProperty
        private Ssl ssl;
        private final Spec spec = new Spec();

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetAddress address2) {
            this.address = address2;
        }

        public RSocketServer.Transport getTransport() {
            return this.transport;
        }

        public void setTransport(RSocketServer.Transport transport) {
            this.transport = transport;
        }

        public String getMappingPath() {
            return this.mappingPath;
        }

        public void setMappingPath(String mappingPath) {
            this.mappingPath = mappingPath;
        }

        public DataSize getFragmentSize() {
            return this.fragmentSize;
        }

        public void setFragmentSize(DataSize fragmentSize) {
            this.fragmentSize = fragmentSize;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public void setSsl(Ssl ssl) {
            this.ssl = ssl;
        }

        public Spec getSpec() {
            return this.spec;
        }

        public static class Spec {
            private String protocols;
            private DataSize maxFramePayloadLength = DataSize.ofBytes(65536L);
            private boolean handlePing;
            private boolean compress;

            public String getProtocols() {
                return this.protocols;
            }

            public void setProtocols(String protocols) {
                this.protocols = protocols;
            }

            public DataSize getMaxFramePayloadLength() {
                return this.maxFramePayloadLength;
            }

            public void setMaxFramePayloadLength(DataSize maxFramePayloadLength) {
                this.maxFramePayloadLength = maxFramePayloadLength;
            }

            public boolean isHandlePing() {
                return this.handlePing;
            }

            public void setHandlePing(boolean handlePing) {
                this.handlePing = handlePing;
            }

            public boolean isCompress() {
                return this.compress;
            }

            public void setCompress(boolean compress) {
                this.compress = compress;
            }
        }
    }
}

