/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryOptionsInitializer;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ConnectionFactoryBeanCreationFailureAnalyzer
extends AbstractFailureAnalyzer<ConnectionFactoryOptionsInitializer.ConnectionFactoryBeanCreationException> {
    private final Environment environment;

    ConnectionFactoryBeanCreationFailureAnalyzer(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, ConnectionFactoryOptionsInitializer.ConnectionFactoryBeanCreationException cause2) {
        return this.getFailureAnalysis(cause2);
    }

    private FailureAnalysis getFailureAnalysis(ConnectionFactoryOptionsInitializer.ConnectionFactoryBeanCreationException cause2) {
        String description = this.getDescription(cause2);
        String action = this.getAction(cause2);
        return new FailureAnalysis(description, action, cause2);
    }

    private String getDescription(ConnectionFactoryOptionsInitializer.ConnectionFactoryBeanCreationException cause2) {
        StringBuilder description = new StringBuilder();
        description.append("Failed to configure a ConnectionFactory: ");
        if (!StringUtils.hasText(cause2.getUrl())) {
            description.append("'url' attribute is not specified and ");
        }
        description.append(String.format("no embedded database could be configured.%n", new Object[0]));
        description.append(String.format("%nReason: %s%n", cause2.getMessage()));
        return description.toString();
    }

    private String getAction(ConnectionFactoryOptionsInitializer.ConnectionFactoryBeanCreationException cause2) {
        StringBuilder action = new StringBuilder();
        action.append(String.format("Consider the following:%n", new Object[0]));
        if (EmbeddedDatabaseConnection.NONE == cause2.getEmbeddedDatabaseConnection()) {
            action.append(String.format("\tIf you want an embedded database (H2), please put it on the classpath.%n", new Object[0]));
        } else {
            action.append(String.format("\tReview the configuration of %s%n.", new Object[]{cause2.getEmbeddedDatabaseConnection()}));
        }
        action.append("\tIf you have database settings to be loaded from a particular profile you may need to activate it").append(this.getActiveProfiles());
        return action.toString();
    }

    private String getActiveProfiles() {
        StringBuilder message2 = new StringBuilder();
        Object[] profiles = this.environment.getActiveProfiles();
        if (ObjectUtils.isEmpty(profiles)) {
            message2.append(" (no profiles are currently active).");
        } else {
            message2.append(" (the profiles ");
            message2.append(StringUtils.arrayToCommaDelimitedString(profiles));
            message2.append(" are currently active).");
        }
        return message2.toString();
    }
}

