/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.neo4j;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;

class Neo4jSpringJclLogging
implements Logging {
    private static final String AUTOMATIC_PREFIX = "org.neo4j.driver.";

    Neo4jSpringJclLogging() {
    }

    public Logger getLog(String name2) {
        Object requestedLog = name2;
        if (!((String)requestedLog).startsWith(AUTOMATIC_PREFIX)) {
            requestedLog = AUTOMATIC_PREFIX + name2;
        }
        Log springJclLog = LogFactory.getLog((String)requestedLog);
        return new SpringJclLogger(springJclLog);
    }

    private static final class SpringJclLogger
    implements Logger {
        private final Log delegate;

        SpringJclLogger(Log delegate) {
            this.delegate = delegate;
        }

        public void error(String message2, Throwable cause2) {
            this.delegate.error(message2, cause2);
        }

        public void info(String format, Object ... params2) {
            this.delegate.info(String.format(format, params2));
        }

        public void warn(String format, Object ... params2) {
            this.delegate.warn(String.format(format, params2));
        }

        public void warn(String message2, Throwable cause2) {
            this.delegate.warn(message2, cause2);
        }

        public void debug(String format, Object ... params2) {
            if (this.isDebugEnabled()) {
                this.delegate.debug(String.format(format, params2));
            }
        }

        public void debug(String message2, Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.delegate.debug(message2, throwable);
            }
        }

        public void trace(String format, Object ... params2) {
            if (this.isTraceEnabled()) {
                this.delegate.trace(String.format(format, params2));
            }
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }
    }
}

