/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class PropertiesMongoConnectionDetails
implements MongoConnectionDetails {
    private final MongoProperties properties;

    public PropertiesMongoConnectionDetails(MongoProperties properties) {
        this.properties = properties;
    }

    @Override
    public ConnectionString getConnectionString() {
        if (this.properties.getUri() != null) {
            return new ConnectionString(this.properties.getUri());
        }
        StringBuilder builder = new StringBuilder("mongodb://");
        if (this.properties.getUsername() != null) {
            builder.append(this.encode(this.properties.getUsername()));
            builder.append(":");
            if (this.properties.getPassword() != null) {
                builder.append(this.encode(this.properties.getPassword()));
            }
            builder.append("@");
        }
        builder.append(this.properties.getHost() != null ? this.properties.getHost() : "localhost");
        if (this.properties.getPort() != null) {
            builder.append(":");
            builder.append(this.properties.getPort());
        }
        if (this.properties.getAdditionalHosts() != null) {
            builder.append(",");
            builder.append(String.join((CharSequence)",", this.properties.getAdditionalHosts()));
        }
        builder.append("/");
        builder.append(this.properties.getMongoClientDatabase());
        List<String> options2 = this.getOptions();
        if (!options2.isEmpty()) {
            builder.append("?");
            builder.append(String.join((CharSequence)"&", options2));
        }
        return new ConnectionString(builder.toString());
    }

    private String encode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    private char[] encode(char[] input) {
        return URLEncoder.encode(new String(input), StandardCharsets.UTF_8).toCharArray();
    }

    @Override
    public MongoConnectionDetails.GridFs getGridFs() {
        return MongoConnectionDetails.GridFs.of(this.properties.getGridfs().getDatabase(), this.properties.getGridfs().getBucket());
    }

    private List<String> getOptions() {
        ArrayList<String> options2 = new ArrayList<String>();
        if (this.properties.getReplicaSetName() != null) {
            options2.add("replicaSet=" + this.properties.getReplicaSetName());
        }
        if (this.properties.getUsername() != null && this.properties.getAuthenticationDatabase() != null) {
            options2.add("authSource=" + this.properties.getAuthenticationDatabase());
        }
        return options2;
    }
}

