/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.logging;

import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportLogger;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class ConditionEvaluationReportLoggingListener
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final LogLevel logLevelForReport;

    public ConditionEvaluationReportLoggingListener() {
        this(LogLevel.DEBUG);
    }

    private ConditionEvaluationReportLoggingListener(LogLevel logLevelForReport) {
        Assert.isTrue(this.isInfoOrDebug(logLevelForReport), "LogLevel must be INFO or DEBUG");
        this.logLevelForReport = logLevelForReport;
    }

    private boolean isInfoOrDebug(LogLevel logLevelForReport) {
        return LogLevel.INFO.equals((Object)logLevelForReport) || LogLevel.DEBUG.equals((Object)logLevelForReport);
    }

    public static ConditionEvaluationReportLoggingListener forLogLevel(LogLevel logLevelForReport) {
        return new ConditionEvaluationReportLoggingListener(logLevelForReport);
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener(new ConditionEvaluationReportListener(applicationContext));
    }

    private final class ConditionEvaluationReportListener
    implements GenericApplicationListener {
        private final ConfigurableApplicationContext context;
        private final ConditionEvaluationReportLogger logger;

        private ConditionEvaluationReportListener(ConfigurableApplicationContext context) {
            Supplier<ConditionEvaluationReport> reportSupplier;
            this.context = context;
            if (context instanceof GenericApplicationContext) {
                ConditionEvaluationReport report = this.getReport();
                reportSupplier = () -> report;
            } else {
                reportSupplier = this::getReport;
            }
            this.logger = new ConditionEvaluationReportLogger(ConditionEvaluationReportLoggingListener.this.logLevelForReport, reportSupplier);
        }

        private ConditionEvaluationReport getReport() {
            return ConditionEvaluationReport.get(this.context.getBeanFactory());
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean supportsEventType(ResolvableType resolvableType) {
            Class<?> type2 = resolvableType.getRawClass();
            if (type2 == null) {
                return false;
            }
            return ContextRefreshedEvent.class.isAssignableFrom(type2) || ApplicationFailedEvent.class.isAssignableFrom(type2);
        }

        @Override
        public boolean supportsSourceType(Class<?> sourceType) {
            return true;
        }

        @Override
        public void onApplicationEvent(ApplicationEvent event2) {
            ApplicationFailedEvent applicationFailedEvent;
            if (event2 instanceof ContextRefreshedEvent) {
                ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event2;
                if (contextRefreshedEvent.getApplicationContext() == this.context) {
                    this.logger.logReport(false);
                }
            } else if (event2 instanceof ApplicationFailedEvent && (applicationFailedEvent = (ApplicationFailedEvent)event2).getApplicationContext() == this.context) {
                this.logger.logReport(true);
            }
        }
    }
}

