/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;

public class ParentAwareNamingStrategy
extends MetadataNamingStrategy
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private boolean ensureUniqueRuntimeObjectNames;

    public ParentAwareNamingStrategy(JmxAttributeSource attributeSource) {
        super(attributeSource);
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        ObjectName name2 = super.getObjectName(managedBean, beanKey);
        if (this.ensureUniqueRuntimeObjectNames) {
            return JmxUtils.appendIdentityToObjectName(name2, managedBean);
        }
        if (this.parentContextContainsSameBean(this.applicationContext, beanKey)) {
            return this.appendToObjectName(name2, "context", ObjectUtils.getIdentityHexString(this.applicationContext));
        }
        return name2;
    }

    private boolean parentContextContainsSameBean(ApplicationContext context, String beanKey) {
        if (context.getParent() == null) {
            return false;
        }
        try {
            this.applicationContext.getParent().getBean(beanKey);
            return true;
        }
        catch (BeansException ex) {
            return this.parentContextContainsSameBean(context.getParent(), beanKey);
        }
    }

    private ObjectName appendToObjectName(ObjectName name2, String key2, String value2) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = name2.getKeyPropertyList();
        keyProperties.put(key2, value2);
        return ObjectNameManager.getInstance(name2.getDomain(), keyProperties);
    }
}

