/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import java.util.HashMap;
import java.util.Map;

public final class AcknowledgeMode {
    private static final Map<String, AcknowledgeMode> knownModes = new HashMap<String, AcknowledgeMode>(3);
    public static final AcknowledgeMode AUTO = new AcknowledgeMode(1);
    public static final AcknowledgeMode CLIENT = new AcknowledgeMode(2);
    public static final AcknowledgeMode DUPS_OK = new AcknowledgeMode(3);
    private final int mode;

    private AcknowledgeMode(int mode2) {
        this.mode = mode2;
    }

    public int getMode() {
        return this.mode;
    }

    public static AcknowledgeMode of(String mode2) {
        String canonicalMode = AcknowledgeMode.canonicalize(mode2);
        AcknowledgeMode knownMode = knownModes.get(canonicalMode);
        try {
            return knownMode != null ? knownMode : new AcknowledgeMode(Integer.parseInt(canonicalMode));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("'" + mode2 + "' is neither a known acknowledge mode (auto, client, or dups_ok) nor an integer value");
        }
    }

    private static String canonicalize(String input) {
        StringBuilder canonicalName = new StringBuilder(input.length());
        input.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
        return canonicalName.toString();
    }

    static {
        knownModes.put("auto", AUTO);
        knownModes.put("client", CLIENT);
        knownModes.put("dupsok", DUPS_OK);
    }
}

